/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.ProductValidationOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Shell;

public class ProductValidateAction
extends Action {
    IProduct fProduct;

    public ProductValidateAction(IProduct product) {
        super(PDEUIMessages.ProductValidateAction_validate, 1);
        this.setImageDescriptor(PDEPluginImages.DESC_VALIDATE_TOOL);
        this.fProduct = product;
    }

    public void run() {
        int i;
        HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
        if (this.fProduct.useFeatures()) {
            IFeatureModel[] features = this.getUniqueFeatures();
            i = 0;
            while (i < features.length) {
                this.addFeaturePlugins(features[i].getFeature(), launchPlugins);
                ++i;
            }
        } else {
            IProductPlugin[] plugins = this.fProduct.getPlugins();
            i = 0;
            while (i < plugins.length) {
                IPluginModelBase model;
                String id = plugins[i].getId();
                if (id != null && (model = PluginRegistry.findModel((String)id)) != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
                ++i;
            }
        }
        try {
            IPluginModelBase[] models = launchPlugins.toArray(new IPluginModelBase[launchPlugins.size()]);
            ProductValidationOperation operation = new ProductValidationOperation(models);
            LaunchPluginValidator.runValidationOperation((LaunchValidationOperation)operation, (IProgressMonitor)new NullProgressMonitor());
            if (!operation.hasErrors()) {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void addFeaturePlugins(IFeature feature, Set<IPluginModelBase> launchPlugins) {
        IFeaturePlugin[] plugins = feature.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            String id = plugins[i].getId();
            String version = plugins[i].getVersion();
            if (id != null && version != null) {
                IPluginModelBase model = PluginRegistry.findModel((String)id, (String)version, (int)1, null);
                if (model == null) {
                    model = PluginRegistry.findModel((String)id);
                }
                if (model != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
            }
            ++i;
        }
    }

    private IFeatureModel[] getUniqueFeatures() {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        IProductFeature[] features = this.fProduct.getFeatures();
        int i = 0;
        while (i < features.length) {
            String id = features[i].getId();
            String version = features[i].getVersion();
            this.addFeatureAndChildren(id, version, list);
            ++i;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private void addFeatureAndChildren(String id, String version, List<IFeatureModel> list) {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.findFeatureModel(id, version);
        if (model == null || list.contains(model)) {
            return;
        }
        list.add(model);
        IFeatureChild[] children = model.getFeature().getIncludedFeatures();
        int i = 0;
        while (i < children.length) {
            this.addFeatureAndChildren(children[i].getId(), children[i].getVersion(), list);
            ++i;
        }
    }
}

