/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEProjectionViewer;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.swt.widgets.Composite;

public abstract class PDEProjectionSourcePage
extends PDESourcePage
implements IProjectionListener {
    private ProjectionSupport fProjectionSupport;
    private IFoldingStructureProvider fFoldingStructureProvider;
    private IColorManager fColorManager = ColorManager.getDefault();
    private ChangeAwareSourceViewerConfiguration fConfiguration = this.createSourceViewerConfiguration(this.fColorManager);

    public PDEProjectionSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
        if (this.fConfiguration != null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fConfiguration);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.createFoldingSupport(projectionViewer);
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        PDEProjectionViewer viewer = new PDEProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.isQuickOutlineEnabled());
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public abstract boolean isQuickOutlineEnabled();

    @Override
    public void dispose() {
        ((ProjectionViewer)this.getSourceViewer()).removeProjectionListener((IProjectionListener)this);
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.fColorManager.dispose();
        if (this.fConfiguration != null) {
            this.fConfiguration.dispose();
        }
        super.dispose();
    }

    private void createFoldingSupport(ProjectionViewer projectionViewer) {
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        ((ProjectionViewer)this.getSourceViewer()).addProjectionListener((IProjectionListener)this);
    }

    public void projectionEnabled() {
        IBaseModel model = this.getInputContext().getModel();
        if (model instanceof IEditingModel) {
            this.fFoldingStructureProvider = this.getFoldingStructureProvider((IEditingModel)model);
            if (this.fFoldingStructureProvider != null) {
                this.fFoldingStructureProvider.initialize();
                IReconciler rec = this.getSourceViewerConfiguration().getReconciler(this.getSourceViewer());
                IReconcilingStrategy startegy = rec.getReconcilingStrategy(new String());
                if (startegy instanceof ReconcilingStrategy) {
                    ((ReconcilingStrategy)startegy).addParticipant(this.fFoldingStructureProvider);
                }
            }
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider(IEditingModel model) {
        return null;
    }

    public void projectionDisabled() {
        this.fFoldingStructureProvider = null;
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("editor.folding");
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (this.fConfiguration == null) {
            return false;
        }
        return this.fConfiguration.affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            ISourceViewer sourceViewer;
            if (this.fConfiguration != null && (sourceViewer = this.getSourceViewer()) != null) {
                this.fConfiguration.adaptToPreferenceChange(event);
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    @Override
    public Object getAdapter(Class key) {
        Object adapter;
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
            return adapter;
        }
        return super.getAdapter(key);
    }

    @Override
    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        this.addQuickOutlineMenuEntry(menu);
        super.editorContextMenuAboutToShow(menu);
    }

    private void addQuickOutlineMenuEntry(IMenuManager menu) {
        if (!this.isQuickOutlineEnabled()) {
            return;
        }
        IAction quickOutlineAction = this.getAction("org.eclipse.pde.ui.quickOutline");
        if (quickOutlineAction == null) {
            return;
        }
        menu.add(quickOutlineAction);
    }

    protected ChangeAwareSourceViewerConfiguration createSourceViewerConfiguration(IColorManager colorManager) {
        return null;
    }
}

