/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.util.ExceptionCollector;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceAdapter;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceMapping;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.egit.ui.internal.decorators.LabelEventJob;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class GitLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IPropertyChangeListener,
IndexDiffChangedListener {
    public static final String DECORATOR_ID = "org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator";
    private static final ExceptionCollector EXCEPTION_COLLECTOR = new ExceptionCollector(UIText.Decorator_exceptionMessage, Activator.getPluginId(), 4, Activator.getDefault().getLog());
    private static final List<String> FONT_IDS = Arrays.asList("org.eclipse.egit.ui.UncommittedChangeFont", "org.eclipse.egit.ui.IgnoredResourceFont");
    private static final List<String> COLOR_IDS = Arrays.asList("org.eclipse.egit.ui.UncommittedChangeBackgroundColor", "org.eclipse.egit.ui.UncommittedChangeForegroundColor", "org.eclipse.egit.ui.IgnoredResourceBackgroundColor", "org.eclipse.egit.ui.IgnoredResourceForegroundColor");
    private static RGB defaultBackgroundRgb;

    public GitLightweightDecorator() {
        this.ensureFontAndColorsCreated(FONT_IDS, COLOR_IDS);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        Activator.addPropertyChangeListener(this);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
        org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().addIndexDiffChangedListener((IndexDiffChangedListener)this);
    }

    private void ensureFontAndColorsCreated(final List<String> actFonts, final List<String> actColors) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                int i = 0;
                while (i < actColors.size()) {
                    theme.getColorRegistry().get((String)actColors.get(i));
                    ++i;
                }
                i = 0;
                while (i < actFonts.size()) {
                    theme.getFontRegistry().get((String)actFonts.get(i));
                    ++i;
                }
                defaultBackgroundRgb = display.getSystemColor(25).getRGB();
            }
        });
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener((IPropertyChangeListener)this);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        Activator.removePropertyChangeListener(this);
        org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().removeIndexDiffChangedListener((IndexDiffChangedListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (Activator.getDefault() == null) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IResource resource = GitLightweightDecorator.getResource(element);
        try {
            if (resource == null) {
                this.decorateResourceMapping(element, decoration);
            } else {
                this.decorateResource(resource, decoration);
            }
        }
        catch (CoreException e) {
            GitLightweightDecorator.handleException(resource, e);
        }
    }

    private void decorateResource(IResource resource, IDecoration decoration) throws CoreException {
        IndexDiffData indexDiffData = GitLightweightDecorator.getIndexDiffDataOrNull(resource);
        if (indexDiffData == null) {
            return;
        }
        DecoratableResourceAdapter decoratableResource = null;
        DecorationHelper helper = new DecorationHelper(Activator.getDefault().getPreferenceStore());
        try {
            decoratableResource = new DecoratableResourceAdapter(indexDiffData, resource);
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(UIText.Decorator_exceptionMessage, e));
        }
        helper.decorate(decoration, decoratableResource);
    }

    static IndexDiffData getIndexDiffDataOrNull(IResource resource) {
        if (resource.getType() == 8) {
            return null;
        }
        if (!resource.exists() && !resource.isPhantom()) {
            return null;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping == null) {
            return null;
        }
        if (mapping.getRepoRelativePath(resource) == null) {
            return null;
        }
        IndexDiffData indexDiffData = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(mapping.getRepository()).getIndexDiff();
        return indexDiffData;
    }

    private void decorateResourceMapping(Object element, IDecoration decoration) throws CoreException {
        DecoratableResourceMapping decoRes;
        ResourceMapping mapping = Utils.getResourceMapping((Object)element);
        try {
            decoRes = new DecoratableResourceMapping(mapping);
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(UIText.Decorator_exceptionMessage, e));
        }
        if (!decoRes.isTracked()) {
            return;
        }
        DecorationHelper helper = new DecorationHelper(Activator.getDefault().getPreferenceStore());
        helper.decorate(decoration, decoRes);
    }

    public static void refresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Activator.getDefault().getWorkbench().getDecoratorManager().update(GitLightweightDecorator.DECORATOR_ID);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed") || prop.equals("org.eclipse.egit.ui.DECORATORS_CHANGED")) {
            this.postLabelEvent();
        } else if (prop.equals("org.eclipse.egit.ui.UncommittedChangeBackgroundColor") || prop.equals("org.eclipse.egit.ui.UncommittedChangeFont") || prop.equals("org.eclipse.egit.ui.UncommittedChangeForegroundColor") || prop.equals("org.eclipse.egit.ui.IgnoredResourceFont") || prop.equals("org.eclipse.egit.ui.IgnoredResourceBackgroundColor") || prop.equals("org.eclipse.egit.ui.IgnoredResourceForegroundColor")) {
            this.ensureFontAndColorsCreated(FONT_IDS, COLOR_IDS);
            this.postLabelEvent();
        }
    }

    public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
        DecoratableResourceHelper.clearState(repository);
        this.postLabelEvent();
    }

    private static IResource getResource(Object actElement) {
        IContributorResourceAdapter adapter;
        IAdaptable adaptable;
        Object element = actElement;
        if (element instanceof ResourceMapping) {
            element = ((ResourceMapping)element).getModelObject();
        }
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable && (resource = CommonUtils.getAdapter(adaptable = (IAdaptable)element, IResource.class)) == null && (adapter = CommonUtils.getAdapter(adaptable, IContributorResourceAdapter.class)) != null) {
            resource = adapter.getAdaptedResource(adaptable);
        }
        return resource;
    }

    private void postLabelEvent() {
        LabelEventJob.getInstance().postLabelEvent(this);
    }

    void fireLabelEvent() {
        final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GitLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    private static void handleException(IResource resource, CoreException e) {
        if (resource == null || resource.isAccessible()) {
            EXCEPTION_COLLECTOR.handleException(e);
        }
    }

    public static class DecorationHelper {
        public static final String BINDING_RESOURCE_NAME = "name";
        public static final String BINDING_BRANCH_NAME = "branch";
        public static final String BINDING_BRANCH_STATUS = "branch_status";
        public static final String BINDING_REPOSITORY_NAME = "repository";
        public static final String BINDING_DIRTY_FLAG = "dirty";
        public static final String BINDING_STAGED_FLAG = "staged";
        public static final String FILE_FORMAT_DEFAULT = "{dirty:>} {name}";
        public static final String FOLDER_FORMAT_DEFAULT = "{dirty:>} {name}";
        public static final String PROJECT_FORMAT_DEFAULT = "{dirty:>} {name}  [{repository} {branch}{ branch_status}]";
        private IPreferenceStore store;
        private static ImageDescriptor trackedImage = new CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif"));
        private static ImageDescriptor untrackedImage = new CachedImageDescriptor(UIIcons.OVR_UNTRACKED);
        private static ImageDescriptor stagedImage = new CachedImageDescriptor(UIIcons.OVR_STAGED);
        private static ImageDescriptor stagedAddedImage = new CachedImageDescriptor(UIIcons.OVR_STAGED_ADD);
        private static ImageDescriptor stagedRemovedImage = new CachedImageDescriptor(UIIcons.OVR_STAGED_REMOVE);
        private static ImageDescriptor conflictImage = new CachedImageDescriptor(UIIcons.OVR_CONFLICT);
        private static ImageDescriptor assumeValidImage = new CachedImageDescriptor(UIIcons.OVR_ASSUMEVALID);
        private static ImageDescriptor dirtyImage = new CachedImageDescriptor(UIIcons.OVR_DIRTY);

        public DecorationHelper(IPreferenceStore preferencesStore) {
            this.store = preferencesStore;
        }

        public void decorate(IDecoration decoration, IDecoratableResource resource) {
            this.decorateFontAndColour(decoration, resource);
            if (resource.isIgnored()) {
                return;
            }
            this.decorateText(decoration, resource);
            this.decorateIcons(decoration, resource);
        }

        private void decorateFontAndColour(IDecoration decoration, IDecoratableResource resource) {
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            Color bc = null;
            Color fc = null;
            Font f = null;
            if (resource.isIgnored()) {
                bc = current.getColorRegistry().get("org.eclipse.egit.ui.IgnoredResourceBackgroundColor");
                fc = current.getColorRegistry().get("org.eclipse.egit.ui.IgnoredResourceForegroundColor");
                f = current.getFontRegistry().get("org.eclipse.egit.ui.IgnoredResourceFont");
            } else if (!resource.isTracked() || resource.isDirty() || resource.staged() != IDecoratableResource.Staged.NOT_STAGED) {
                bc = current.getColorRegistry().get("org.eclipse.egit.ui.UncommittedChangeBackgroundColor");
                fc = current.getColorRegistry().get("org.eclipse.egit.ui.UncommittedChangeForegroundColor");
                f = current.getFontRegistry().get("org.eclipse.egit.ui.UncommittedChangeFont");
            }
            if (bc != null) {
                this.setBackgroundColor(decoration, bc);
            }
            if (fc != null) {
                decoration.setForegroundColor(fc);
            }
            if (f != null) {
                decoration.setFont(f);
            }
        }

        private void setBackgroundColor(IDecoration decoration, Color color) {
            if (!color.getRGB().equals((Object)defaultBackgroundRgb)) {
                decoration.setBackgroundColor(color);
            }
        }

        private void decorateText(IDecoration decoration, IDecoratableResource resource) {
            String format = "";
            switch (resource.getType()) {
                case 1: {
                    format = this.store.getString("decorator_filetext_decoration");
                    break;
                }
                case 2: 
                case 16: {
                    format = this.store.getString("decorator_foldertext_decoration");
                    break;
                }
                case 39321: {
                    if (resource.getRepositoryName() != null && resource.getBranch() != null) {
                        format = this.store.getString("decorator_projecttext_decoration");
                        break;
                    }
                    format = this.store.getString("decorator_foldertext_decoration");
                    break;
                }
                case 4: {
                    format = this.store.getString("decorator_projecttext_decoration");
                }
            }
            HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put(BINDING_RESOURCE_NAME, resource.getName());
            bindings.put(BINDING_REPOSITORY_NAME, resource.getRepositoryName());
            bindings.put(BINDING_BRANCH_NAME, resource.getBranch());
            bindings.put(BINDING_BRANCH_STATUS, resource.getBranchStatus());
            bindings.put(BINDING_DIRTY_FLAG, resource.isDirty() ? ">" : null);
            bindings.put(BINDING_STAGED_FLAG, resource.staged() != IDecoratableResource.Staged.NOT_STAGED ? "*" : null);
            DecorationHelper.decorate(decoration, format, bindings);
        }

        private void decorateIcons(IDecoration decoration, IDecoratableResource resource) {
            ImageDescriptor overlay = null;
            if (resource.isTracked()) {
                if (this.store.getBoolean("decorator_show_tracked_icon")) {
                    overlay = trackedImage;
                }
                if (this.store.getBoolean("decorator_show_assume_valid_icon") && resource.isAssumeValid()) {
                    overlay = assumeValidImage;
                }
                IDecoratableResource.Staged staged = resource.staged();
                if (this.store.getBoolean("decorator_show_staged_icon") && staged != IDecoratableResource.Staged.NOT_STAGED) {
                    overlay = staged == IDecoratableResource.Staged.ADDED ? stagedAddedImage : (staged == IDecoratableResource.Staged.REMOVED ? stagedRemovedImage : stagedImage);
                }
                if (this.store.getBoolean("decorator_show_dirty_icon") && resource.isDirty()) {
                    overlay = dirtyImage;
                }
                if (this.store.getBoolean("decorator_show_conflicts_icon") && resource.hasConflicts()) {
                    overlay = conflictImage;
                }
            } else if (this.store.getBoolean("decorator_show_untracked_icon")) {
                overlay = untrackedImage;
            }
            decoration.addOverlay(overlay);
        }

        public static void decorate(IDecoration decoration, String format, Map<String, String> bindings) {
            String suffixString;
            StringBuilder suffix;
            StringBuilder prefix;
            block13: {
                prefix = new StringBuilder();
                suffix = new StringBuilder();
                StringBuilder output = prefix;
                int length = format.length();
                int start = -1;
                int end = length;
                while ((end = format.indexOf(123, start)) > -1) {
                    output.append(format.substring(start + 1, end));
                    start = format.indexOf(125, end);
                    if (start > -1) {
                        char c;
                        String s;
                        String key = format.substring(end + 1, start);
                        boolean spaceBefore = false;
                        boolean spaceAfter = false;
                        if (key.indexOf(58) > -1) {
                            String[] keyAndBinding = key.split(":", 2);
                            key = keyAndBinding[0];
                            if (keyAndBinding.length > 1 && bindings.get(key) != null) {
                                bindings.put(key, keyAndBinding[1]);
                            }
                        } else {
                            if (key.charAt(0) == ' ') {
                                spaceBefore = true;
                                key = key.substring(1);
                            }
                            if (key.charAt(key.length() - 1) == ' ') {
                                spaceAfter = true;
                                key = key.substring(0, key.length() - 1);
                            }
                        }
                        if (key.equals(BINDING_RESOURCE_NAME)) {
                            output = suffix;
                            s = null;
                        } else {
                            s = bindings.get(key);
                        }
                        if (s != null) {
                            if (spaceBefore) {
                                output.append(' ');
                            }
                            output.append(s);
                            if (!spaceAfter) continue;
                            output.append(' ');
                            continue;
                        }
                        int curLength = output.length();
                        if (curLength <= 0 || (c = output.charAt(curLength - 1)) != ':' && c != '@') continue;
                        output.deleteCharAt(curLength - 1);
                        continue;
                    }
                    output.append(format.substring(end, length));
                    break block13;
                }
                output.append(format.substring(start + 1, length));
            }
            String prefixString = prefix.toString().replaceAll("^\\s+", "");
            if (prefixString.length() > 0) {
                decoration.addPrefix(TextProcessor.process((String)prefixString, (String)"()[]."));
            }
            if ((suffixString = suffix.toString().replaceAll("\\s+$", "")).length() > 0) {
                decoration.addSuffix(TextProcessor.process((String)suffixString, (String)"()[]."));
            }
        }

        private static class CachedImageDescriptor
        extends ImageDescriptor {
            ImageDescriptor descriptor;
            ImageData data;

            public CachedImageDescriptor(ImageDescriptor descriptor) {
                this.descriptor = descriptor;
            }

            public ImageData getImageData() {
                if (this.data == null) {
                    this.data = this.descriptor.getImageData();
                }
                return this.data;
            }
        }
    }
}

