/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;

class ASTMatchingFragmentFinder
extends GenericVisitor {
    private ASTFragment fFragmentToMatch;
    private Set<IASTFragment> fMatches = new HashSet<IASTFragment>();

    public static IASTFragment[] findMatchingFragments(ASTNode scope, ASTFragment toMatch) {
        return new ASTMatchingFragmentFinder(toMatch).findMatches(scope);
    }

    private ASTMatchingFragmentFinder(ASTFragment toMatch) {
        super(true);
        this.fFragmentToMatch = toMatch;
    }

    private IASTFragment[] findMatches(ASTNode scope) {
        this.fMatches.clear();
        scope.accept((ASTVisitor)this);
        return this.getMatches();
    }

    private IASTFragment[] getMatches() {
        return this.fMatches.toArray(new IASTFragment[this.fMatches.size()]);
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    protected boolean visitNode(ASTNode node) {
        IASTFragment[] localMatches = this.fFragmentToMatch.getMatchingFragmentsWithNode(node);
        int i = 0;
        while (i < localMatches.length) {
            this.fMatches.add(localMatches[i]);
            ++i;
        }
        return true;
    }
}

