/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.autdetails;

import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.autdetails.IAutDetailsProcessor;
import org.eclipse.rcptt.util.FileUtil;

public class ZipAutDetailsProcessor
implements IAutDetailsProcessor {
    private ZipOutputStream zout;

    public ZipAutDetailsProcessor(String pathToZip) {
        if (pathToZip != null) {
            try {
                File file = new File(pathToZip);
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            }
            catch (IOException e) {
                Q7LaunchingPlugin.log((Throwable)e);
            }
        }
    }

    @Override
    public void addFile(String name, InputStream in) {
        try {
            try {
                this.zout.putNextEntry(new ZipEntry(name));
                FileUtil.copyNoClose((InputStream)in, (OutputStream)this.zout);
                this.zout.closeEntry();
            }
            catch (IOException e) {
                Q7LaunchingPlugin.log((Throwable)e);
                Closeables.closeQuietly((Closeable)in);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
    }

    @Override
    public void addFile(String name, Properties properties) {
        try {
            this.zout.putNextEntry(new ZipEntry(name));
            properties.store(this.zout, "");
            this.zout.closeEntry();
        }
        catch (IOException e) {
            Q7LaunchingPlugin.log((Throwable)e);
        }
    }

    @Override
    public void closeStream() {
        try {
            this.zout.close();
        }
        catch (IOException e) {
            Q7LaunchingPlugin.log((Throwable)e);
        }
    }
}

