/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.reporting.Procedure1;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.internal.ui.player.DetailUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.JobCollectorExtensions;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.jobs.JobsManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.ui.IJobCollector;
import org.eclipse.rcptt.tesla.ui.SWTTeslaActivator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class UIJobCollector
implements IJobChangeListener {
    private final Map<Job, JobInfo> jobs = Collections.synchronizedMap(new IdentityHashMap());
    private boolean state;
    private boolean needDisable = false;
    private long stepModeNext = 0L;
    private static final Set<String> IGNORED_BY_DEFAULT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.eclipse.jdt.internal.core.search.processing.JobManager$1$ProgressJob", "org.eclipse.ui.internal.progress.ProgressViewUpdater$1", "org.eclipse.ui.internal.progress.WorkbenchSiteProgressService$SiteUpdateJob", "org.eclipse.ui.dialogs.FilteredItemsSelectionDialog.RefreshProgressMessageJob", "org.eclipse.ui.dialogs.FilteredItemsSelectionDialog$RefreshProgressMessageJob", "org.eclipse.ui.internal.progress.AnimationManager$1", "org.eclipse.ui.internal.progress.ProgressManager$6", "org.eclipse.ui.internal.progress.TaskBarProgressManager$2", "org.eclipse.ui.internal.views.markers.CachedMarkerBuilder$1")));
    private long lastSuccessTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobInfo getOrCreateJobInfo(Job job) {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            JobInfo rv = this.jobs.get(job);
            if (rv == null) {
                rv = new JobInfo(job);
                JobsManager.getInstance().removeCanceled(job);
                if (TeslaFeatures.isActivityLogging()) {
                    String msg = "waiting for job: " + job.getClass().getName();
                    System.out.println(msg);
                    Q7LoggingManager.get((String)"jobs").log(msg, null);
                    ReportManager.appendLogExtra((String)msg);
                }
                this.jobs.put(job, rv);
            }
            return rv;
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
        this.getOrCreateJobInfo(event.getJob()).awake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(IJobChangeEvent event) {
        JobsManager.getInstance().removeCanceled(event.getJob());
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            boolean reschedule = TeslaSWTAccess.getJobEventReSchedule(event) && this.state;
            this.getOrCreateJobInfo(event.getJob()).done(reschedule);
            if (this.needDisable && this.isJoinEmpty()) {
                this.disable();
            }
            if (!reschedule) {
                this.jobs.remove(event.getJob());
            }
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
        if (!this.state) {
            return;
        }
        JobInfo jobInfo = this.getOrCreateJobInfo(event.getJob());
        jobInfo.scheduled(event.getDelay());
        if (IJobCollector.JobStatus.REQUIRED.equals((Object)jobInfo.status)) {
            if (event.getJob().belongsTo(TeslaSWTAccess.getDecoratorManagerFamily())) {
                JobsManager.getInstance().nulifyTime(event.getJob());
            }
            if (jobInfo.rescheduleCounter < (long)TeslaLimits.getJobNullifyRescheduleMaxValue()) {
                JobsManager.getInstance().nulifyTime(event.getJob());
            }
        }
    }

    protected IJobCollector.JobStatus calcJobStatus(Job job, long delay) {
        return UIJobCollector.detectJobStatus(job, delay);
    }

    public static IJobCollector.JobStatus detectJobStatus(Job job, long delay) {
        IJobCollector[] collectors;
        IJobCollector.JobStatus status = null;
        IJobCollector[] iJobCollectorArray = collectors = JobCollectorExtensions.getDefault().getCollectors();
        int n = collectors.length;
        int n2 = 0;
        while (n2 < n) {
            IJobCollector cl = iJobCollectorArray[n2];
            IJobCollector.JobStatus jobStatus = cl.testJob(job);
            if (jobStatus != null && !jobStatus.equals((Object)IJobCollector.JobStatus.UNKNOWN) && status == null) {
                status = jobStatus;
                break;
            }
            ++n2;
        }
        if (status == null) {
            String jClassName;
            if (delay < (long)TeslaLimits.getJobWaitForDelayedTimeout()) {
                status = IJobCollector.JobStatus.REQUIRED;
            }
            if (job.belongsTo(UIJobCollector.getFamilyAutoBuild())) {
                status = IJobCollector.JobStatus.REQUIRED;
            }
            if (IGNORED_BY_DEFAULT.contains(jClassName = job.getClass().getName())) {
                status = IJobCollector.JobStatus.IGNORED;
            }
        }
        return status;
    }

    public void sleeping(IJobChangeEvent event) {
        this.getOrCreateJobInfo(event.getJob()).sleeping();
    }

    private static boolean isModal(Shell shell) {
        return PlayerWidgetUtils.isModal(shell);
    }

    private String getJobMessage(Job job) {
        return this.getJobMessage(this.getOrCreateJobInfo(job));
    }

    private String getJobMessage(JobInfo jobInfo) {
        Job job = jobInfo.job;
        StringBuilder msg = new StringBuilder();
        msg.append("Job: ").append(job.getName()).append("\n");
        msg.append("\tclass: ").append(job.getClass().getName()).append(" ").append(DetailUtils.extractSupers(job.getClass())).append("\n");
        Long startTime = jobInfo.startingTime;
        long currentTimeMillis = System.currentTimeMillis();
        long time = 0L;
        if (startTime != null) {
            time = currentTimeMillis - startTime;
        }
        msg.append("\tworking time: ").append(time).append("(ms)\n");
        msg.append("\tstate: ").append(job.getState()).append("\n");
        ISchedulingRule rule = job.getRule();
        if (rule != null) {
            if (rule instanceof IResource) {
                IPath location = ((IResource)rule).getLocation();
                msg.append("\trule is resource: ").append(location != null ? location.toOSString() : "/").append("\n");
            } else {
                msg.append("\trule: ").append(rule.toString()).append("\n");
            }
        } else {
            msg.append("\trule: Empty\n");
        }
        Thread thread = job.getThread();
        if (thread != null) {
            StackTraceElement[] trace = thread.getStackTrace();
            msg.append("\tstack trace: \n");
            int c = 0;
            StackTraceElement[] stackTraceElementArray = trace;
            int n = trace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (c > 15) {
                    msg.append("\t\t....");
                    break;
                }
                ++c;
                msg.append("\t\t" + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + (stackTraceElement.getFileName() != null ? " [" + stackTraceElement.getFileName() + "]" : "")).append("\n");
                ++n2;
            }
        }
        return msg.toString();
    }

    private boolean logReturnResult(boolean result, List<Job> realJobs, List<Job> jobsInUI, Q7WaitInfoRoot info) {
        try {
            long curTime = System.currentTimeMillis();
            if (result) {
                this.lastSuccessTime = curTime;
                return result;
            }
            for (Job job : jobsInUI) {
                Q7WaitUtils.updateInfo((String)"job.ui", (String)job.getClass().getName(), (Q7WaitInfoRoot)info);
            }
            for (Job job : realJobs) {
                Q7WaitUtils.updateInfo((String)"job", (String)job.getClass().getName(), (Q7WaitInfoRoot)info);
            }
            if (this.lastSuccessTime == 0L) {
                this.lastSuccessTime = curTime;
                return result;
            }
            if (curTime - this.lastSuccessTime > TeslaLimits.getJobLoggingTimeout()) {
                this.lastSuccessTime = curTime;
                this.logJobInformation(realJobs, jobsInUI);
            }
        }
        catch (Exception e) {
            SWTTeslaActivator.log(e);
        }
        return result;
    }

    static String getCurrentReportNodeName() {
        final String[] rv = new String[1];
        ReportManager.getCurrentReportNode().update((Procedure1)new Procedure1<Node>(){

            public void apply(Node node) {
                rv[0] = node.getName();
            }
        });
        return rv[0];
    }

    private void logJobInformation(List<Job> realJobs, List<Job> jobsInUI) {
        ArrayList<Job> otherJobs = new ArrayList<Job>(this.jobs.keySet());
        HashSet<Job> jobInStepMode = new HashSet<Job>();
        for (Job job : otherJobs) {
            if (!this.getOrCreateJobInfo(job).jobInStepMode) continue;
            jobInStepMode.add(job);
        }
        otherJobs.removeAll(realJobs);
        otherJobs.removeAll(jobsInUI);
        otherJobs.removeAll(jobInStepMode);
        StringBuilder reportMessage = new StringBuilder();
        reportMessage.append("----->>> Waiting for Jobs during execution: ").append(UIJobCollector.getCurrentReportNodeName()).append(" -----<<<< \n");
        if (realJobs.size() > 0) {
            reportMessage.append("---> Standalone Jobs:\n");
            for (Job job : realJobs) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        if (jobInStepMode.size() > 0) {
            reportMessage.append("---> Jobs in Stepping mode:\n");
            for (Job job : jobInStepMode) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        if (jobsInUI.size() > 0) {
            reportMessage.append("---> Jobs doing UI:\n");
            for (Job job : jobsInUI) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        if (otherJobs.size() > 0) {
            reportMessage.append("---> Other jobs:\n");
            for (Job job : otherJobs) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        SWTTeslaActivator.logToReport(reportMessage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(ContextManagement.Context context, Q7WaitInfoRoot info) {
        Job job;
        ArrayList<Job> realJobs = new ArrayList<Job>();
        long current = System.currentTimeMillis();
        boolean wasInStepMode = false;
        ArrayList<Job> jobsInUI = new ArrayList<Job>();
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            this.removeCanceledJobs();
            if (this.jobs.isEmpty()) {
                return this.logReturnResult(true, realJobs, jobsInUI, info);
            }
            for (JobInfo jobInfo : this.jobs.values()) {
                if (!jobInfo.isActive()) continue;
                Job job2 = jobInfo.job;
                IJobCollector[] collectors = JobCollectorExtensions.getDefault().getCollectors();
                boolean allowSkip = true;
                IJobCollector[] iJobCollectorArray = collectors;
                int n = collectors.length;
                int n2 = 0;
                while (n2 < n) {
                    IJobCollector ext = iJobCollectorArray[n2];
                    if (ext.noSkipMode(job2)) {
                        allowSkip = false;
                        break;
                    }
                    ++n2;
                }
                if (allowSkip) continue;
                long jobStartTime = jobInfo.startingTime;
                if (jobInfo.checkForTimeout) {
                    if (jobStartTime + TeslaLimits.getStepModeEnableTimeout() < current && job2.getState() == 4 && this.stepModeNext < current) {
                        ContextManagement.Context ctx;
                        Thread thread = job2.getThread();
                        if (thread == null) {
                            SWTTeslaActivator.logToReport("Active job " + job2.getName() + " has no thread");
                            jobInfo.done(false);
                        }
                        if ((ctx = ContextManagement.makeContext((StackTraceElement[])thread.getStackTrace())).contains("java.lang.Thread", "sleep") || ctx.contains("java.lang.Object", "wait")) {
                            if (!jobInfo.jobInStepMode) {
                                SWTTeslaActivator.logToReport("---->>> Begin step mode for Job: " + UIJobCollector.getCurrentReportNodeName() + " <<---\n(skipping)" + this.getJobMessage(jobInfo));
                            }
                            jobInfo.jobInStepMode = true;
                            wasInStepMode = true;
                            continue;
                        }
                    }
                    long timeout = TeslaLimits.getJobTimeout();
                    if (job2.belongsTo(UIJobCollector.getFamilyAutoBuild())) {
                        timeout = TeslaLimits.getAutoBuildJobTimeout();
                    }
                    if (jobInfo.jobInStepMode) {
                        timeout = TeslaLimits.getStepModeTimeout();
                    }
                    if (job2.getClass().getName().contains("org.eclipse.debug.internal.ui.DebugUIPlugin")) {
                        timeout = TeslaLimits.getDebugJobTimeout();
                    }
                    if (jobStartTime + timeout < current) {
                        if (context != null && TeslaEventManager.getManager().isJobInSyncExec(job2, context)) {
                            jobInfo.checkForTimeout = false;
                        } else {
                            this.printJobTimeoutLogEntry(job2);
                            continue;
                        }
                    }
                }
                if (context != null) {
                    if (this.isAsyncSupported() && JobsManager.getInstance().isFinishedAsyncJob(job2) && context.containsClass(job2.getClass().getName())) {
                        jobsInUI.add(job2);
                        continue;
                    }
                    if (this.isSyncSupported() && context.contains(Display.class.getName(), "sleep") && TeslaEventManager.getManager().isJobInSyncExec(job2, context)) {
                        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
                        Set<String> names = this.getSuperClassNames(job2);
                        Thread jobThread = null;
                        ContextManagement.Context jobContext = null;
                        for (Map.Entry<Thread, StackTraceElement[]> thread : traces.entrySet()) {
                            ContextManagement.Context ctx = ContextManagement.makeContext((StackTraceElement[])thread.getValue());
                            for (String name : names) {
                                if (!ctx.contains("org.eclipse.core.internal.jobs.Worker", "run") || !ctx.contains(name, "run")) continue;
                                jobThread = thread.getKey();
                                jobContext = ctx;
                            }
                        }
                        if (jobThread != null && jobContext != null && jobContext.contains("org.eclipse.ui.internal.UISynchronizer", "syncExec") && jobContext.contains("org.eclipse.ui.internal.Semaphore", "acquire") && !SWTUIPlayer.hasRunnables(PlatformUI.getWorkbench().getDisplay())) {
                            List execs = TeslaEventManager.getManager().getSyncExecs();
                            boolean toContinue = true;
                            for (ContextManagement.Context context2 : execs) {
                                StackTraceElement[] stackTrace = context2.getStackTrace();
                                String className = null;
                                int i = 0;
                                while (i < stackTrace.length) {
                                    if (stackTrace[i].getClassName().equals("org.eclipse.swt.widgets.Display") && stackTrace[i].getMethodName().equals("syncExec")) {
                                        className = stackTrace[i + 1].getClassName();
                                        break;
                                    }
                                    ++i;
                                }
                                if (context.containsClass(className)) continue;
                                toContinue = false;
                            }
                            if (toContinue) {
                                jobsInUI.add(job2);
                                continue;
                            }
                        }
                    }
                }
                if (!jobInfo.isActive()) continue;
                realJobs.add(job2);
            }
        }
        if (!jobsInUI.isEmpty() && realJobs.size() == 1 && ((Job)realJobs.get(0)).belongsTo(UIJobCollector.getFamilyAutoBuild())) {
            realJobs.clear();
        }
        if (realJobs.size() == 1 && (job = (Job)realJobs.iterator().next()).belongsTo(UIJobCollector.getFamilyAutoBuild())) {
            int flags = TeslaSWTAccess.getJobFlags(job);
            if ((flags & 0xFF) == 8) {
                return this.logReturnResult(true, realJobs, jobsInUI, info);
            }
            final Display display = PlatformUI.getWorkbench().getDisplay();
            final boolean[] value = new boolean[1];
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell[] shells;
                    Shell[] shellArray = shells = display.getShells();
                    int n = shells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Shell shell = shellArray[n2];
                        if (UIJobCollector.isModal(shell)) {
                            value[0] = true;
                        }
                        ++n2;
                    }
                }
            });
            if (value[0]) {
                return this.logReturnResult(true, realJobs, jobsInUI, info);
            }
            if (job.getState() != 0) {
                return this.logReturnResult(false, realJobs, jobsInUI, info);
            }
            return this.logReturnResult(true, realJobs, jobsInUI, info);
        }
        if (wasInStepMode && realJobs.isEmpty()) {
            this.stepModeNext = current + TeslaLimits.getStepModeStepTime();
        }
        return this.logReturnResult(realJobs.isEmpty(), realJobs, jobsInUI, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCanceledJobs() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            for (JobInfo job : this.jobs.values()) {
                if (!JobsManager.getInstance().isCanceled(job.job)) continue;
                job.cancel();
            }
            List<Job> find = Arrays.asList(Job.getJobManager().find(null));
            for (Job job : this.jobs.keySet()) {
                if (find.contains(job)) continue;
                this.getOrCreateJobInfo(job).cancel();
            }
        }
    }

    private Set<String> getSuperClassNames(Job job) {
        Class<?> cl = job.getClass();
        HashSet<String> names = new HashSet<String>();
        while (!cl.equals(Job.class)) {
            names.add(cl.getName());
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) break;
            cl = superclass;
        }
        return names;
    }

    private void printJobTimeoutLogEntry(Job job) {
        this.getOrCreateJobInfo(job).printJobTimeoutLogEntry();
    }

    protected boolean isSyncSupported() {
        return true;
    }

    protected boolean isAsyncSupported() {
        return true;
    }

    public void enable() {
        Job[] find;
        this.state = true;
        this.needDisable = false;
        Job[] jobArray = find = Job.getJobManager().find(null);
        int n = find.length;
        int n2 = 0;
        while (n2 < n) {
            IJobCollector.JobStatus status;
            Job job = jobArray[n2];
            if ((job instanceof UIJob && job.getState() != 1 || job.belongsTo(UIJobCollector.getFamilyAutoBuild())) && IJobCollector.JobStatus.REQUIRED.equals((Object)(status = this.calcJobStatus(job, 0L)))) {
                JobInfo jobInfo;
                if (job.belongsTo(TeslaSWTAccess.getDecoratorManagerFamily())) {
                    JobsManager.getInstance().nulifyTime(job);
                }
                if ((jobInfo = this.getOrCreateJobInfo(job)).rescheduleCounter < (long)TeslaLimits.getJobNullifyRescheduleMaxValue()) {
                    JobsManager.getInstance().nulifyTime(job);
                }
            }
            ++n2;
        }
    }

    private static Object getFamilyAutoBuild() {
        try {
            return ResourcesPlugin.FAMILY_AUTO_BUILD;
        }
        catch (Throwable throwable) {
            return UIJobCollector.class;
        }
    }

    public void disable() {
        this.state = false;
        this.needDisable = false;
    }

    public void setNeedDisable() {
        this.needDisable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            return this.jobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> getJobs() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            ArrayList<Job> rv = new ArrayList<Job>();
            for (JobInfo info : this.jobs.values()) {
                if (!info.isActive()) continue;
                rv.add(info.job);
            }
            return rv;
        }
    }

    public void join(long timeout) throws InterruptedException {
        SWTTeslaActivator.debugLog("UIJobCollector is going to join");
        long startTime = System.currentTimeMillis();
        while (true) {
            this.removeCanceledJobs();
            long delta = System.currentTimeMillis() - startTime;
            if (delta > timeout || this.isJoinEmpty()) break;
            List<Job> jobs2 = this.getJobs();
            for (Job job : jobs2) {
                SWTTeslaActivator.debugLog("Waiting for job:" + job.getName() + " " + job.getState());
            }
            SWTTeslaActivator.debugLog("UIJobCollector is going to join");
            Thread.sleep(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJoinEmpty() {
        int flags;
        Job job;
        ArrayList<Job> realJobs = new ArrayList<Job>();
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            block8: {
                if (!this.jobs.isEmpty()) break block8;
                return true;
            }
            for (JobInfo jobInfo : this.jobs.values()) {
                if (!jobInfo.isActive()) continue;
                Job job2 = jobInfo.job;
                Set<String> names = this.getSuperClassNames(job2);
                Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
                boolean toContinue = false;
                block5: for (Map.Entry<Thread, StackTraceElement[]> thread : traces.entrySet()) {
                    ContextManagement.Context ctx = ContextManagement.makeContext((StackTraceElement[])thread.getValue());
                    for (String name : names) {
                        if (!ctx.contains(name, "run") && !ctx.contains(name, "runInUIThread") || !ctx.contains("org.eclipse.swt.widgets.Display", "sleep")) continue;
                        toContinue = true;
                        continue block5;
                    }
                }
                if (toContinue) continue;
                realJobs.add(job2);
            }
        }
        if (realJobs.size() == 1 && (job = (Job)realJobs.iterator().next()).belongsTo(UIJobCollector.getFamilyAutoBuild()) && (flags = TeslaSWTAccess.getJobFlags(job)) == 8) {
            return true;
        }
        return realJobs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            this.jobs.clear();
            this.stepModeNext = 0L;
        }
    }

    private class JobInfo {
        private final Job job;
        private IJobCollector.JobStatus status;
        private boolean sleeping = false;
        private boolean infoPrinted = false;
        private long startingTime = System.currentTimeMillis();
        private long rescheduleCounter = 0L;
        private boolean jobInStepMode = false;
        private boolean checkForTimeout = true;
        private boolean done = false;

        JobInfo(Job job) {
            this.job = job;
            this.status = UIJobCollector.this.calcJobStatus(job, 0L);
        }

        synchronized void awake() {
            this.sleeping = false;
            this.done = false;
            this.startingTime = System.currentTimeMillis();
        }

        synchronized void sleeping() {
            this.sleeping = true;
            this.done = false;
            this.infoPrinted = false;
        }

        synchronized void done(boolean reschedule) {
            if (!reschedule) {
                this.done = true;
            } else {
                ++this.rescheduleCounter;
            }
        }

        synchronized void cancel() {
            this.done = true;
        }

        synchronized void printJobTimeoutLogEntry() {
            if (!this.infoPrinted) {
                this.infoPrinted = true;
                SWTTeslaActivator.logToReport("---->>> Waiting timeout exceed then execute: " + UIJobCollector.getCurrentReportNodeName() + " <<---\n(skipping)" + UIJobCollector.this.getJobMessage(this));
            }
        }

        synchronized boolean isActive() {
            if (this.done) {
                return false;
            }
            if (!IJobCollector.JobStatus.REQUIRED.equals((Object)this.status)) {
                return false;
            }
            if (this.sleeping) {
                long delay = this.startingTime - System.currentTimeMillis();
                return delay < (long)TeslaLimits.getJobWaitForDelayedTimeout();
            }
            return true;
        }

        synchronized void scheduled(long delay) {
            this.sleeping = false;
            this.done = false;
            this.checkForTimeout = true;
            this.jobInStepMode = false;
            this.status = UIJobCollector.this.calcJobStatus(this.job, delay);
            this.startingTime = System.currentTimeMillis() + delay;
        }

        public String toString() {
            return this.job.toString();
        }
    }
}

