/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class IUComparator
extends ViewerComparator {
    public static final int IU_NAME = 0;
    public static final int IU_ID = 1;
    private int key;
    private boolean showingId = false;

    public IUComparator(int sortKey) {
        this.key = sortKey;
        this.showingId = sortKey == 1;
    }

    public void useColumnConfig(IUColumnConfig[] columnConfig) {
        int i = 0;
        while (i < columnConfig.length) {
            if (columnConfig[i].getColumnType() == 0) {
                this.showingId = true;
                break;
            }
            ++i;
        }
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        String key2;
        String key1;
        IInstallableUnit iu1 = ProvUI.getAdapter(obj1, IInstallableUnit.class);
        IInstallableUnit iu2 = ProvUI.getAdapter(obj2, IInstallableUnit.class);
        if (iu1 == null || iu2 == null) {
            return super.compare(viewer, obj1, obj2);
        }
        if (this.key == 0) {
            key1 = iu1.getProperty("org.eclipse.equinox.p2.name", null);
            if (key1 == null) {
                key1 = this.showingId ? "" : iu1.getId();
            }
            if ((key2 = iu2.getProperty("org.eclipse.equinox.p2.name", null)) == null) {
                key2 = this.showingId ? "" : iu2.getId();
            }
        } else {
            key1 = iu1.getId();
            key2 = iu2.getId();
        }
        int result = 0;
        result = key1.compareToIgnoreCase(key2);
        if (result == 0) {
            result = iu2.getVersion().compareTo((Object)iu1.getVersion());
        }
        return result;
    }
}

