/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.ServletPrintWriter;
import org.eclipse.help.internal.webapp.utils.Utils;

public class ValidatorServlet
extends HttpServlet {
    private static final long serialVersionUID = -3783758607845176051L;
    private Hashtable<String, HttpServlet> servletTable = new Hashtable();

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String baseURL = req.getRequestURL().toString();
        baseURL = baseURL.substring(0, baseURL.indexOf(req.getServletPath()));
        Locale locale = UrlUtil.getLocaleObj(req, resp);
        String service = req.getRequestURL().toString().substring(baseURL.length() + "/vs".length());
        try {
            HttpServletResponseAdv response = new HttpServletResponseAdv(resp);
            HttpServlet servlet = this.getServlet(service);
            ServletConfig config = this.getServletConfig();
            servlet.init(config);
            servlet.service((ServletRequest)req, (ServletResponse)response);
            if (this.isSecure(req, response)) {
                response.commitOutput();
            }
        }
        catch (Exception ex) {
            String errorMsg = WebappResources.getString("cantCreateServlet", locale, service);
            HelpWebappPlugin.logError(errorMsg, ex);
            PrintWriter writer = resp.getWriter();
            writer.println(errorMsg);
            ex.printStackTrace(writer);
            resp.sendError(500);
        }
    }

    private HttpServlet getServlet(String name) throws CoreException {
        HttpServlet servlet = this.servletTable.get(name);
        if (servlet == null) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.webapp.validatedServlet");
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config2 = iConfigurationElementArray[n2];
                String alias = config2.getAttribute("alias");
                if (alias != null && this.isMatch(alias, name)) {
                    servlet = (HttpServlet)config2.createExecutableExtension("class");
                    this.servletTable.put(name, servlet);
                    break;
                }
                ++n2;
            }
        }
        return servlet;
    }

    private boolean isMatch(String alias, String name) {
        int index = name.indexOf(alias);
        if (index == 0) {
            int offset = alias.length();
            if (name.length() == offset) {
                return true;
            }
            char ch = name.charAt(offset);
            if (ch == '/' || ch == '?') {
                return true;
            }
        }
        return false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    public boolean isSecure(HttpServletRequest req, HttpServletResponseAdv resp) throws SecurityException {
        Enumeration names = req.getParameterNames();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> scripts = new ArrayList<String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String val = req.getParameter(name);
            values.add(val);
            if (this.replaceAll(val, '+', "").indexOf("<script") <= -1) continue;
            scripts.add(val);
        }
        if (resp.getWriter() != null) {
            String data = resp.getString();
            int s = 0;
            while (s < scripts.size()) {
                if (data.indexOf((String)scripts.get(s)) > -1) {
                    throw new SecurityException("Potential cross-site scripting detected.");
                }
                ++s;
            }
        }
        return true;
    }

    public String replaceAll(String str, char remove, String add) {
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < str.length()) {
            char ch = str.charAt(s);
            if (ch == remove) {
                buffer.append(add);
            } else {
                buffer.append(ch);
            }
            ++s;
        }
        return buffer.toString();
    }

    private class HttpServletResponseAdv
    extends HttpServletResponseWrapper {
        private HttpServletResponse response;
        private ServletPrintWriter writer;
        private ServletOutputStream stream;

        public HttpServletResponseAdv(HttpServletResponse response) {
            super(response);
            this.response = response;
        }

        public PrintWriter getWriter() {
            if (this.writer == null && this.stream == null) {
                this.writer = new ServletPrintWriter();
            }
            return this.writer;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.stream == null && this.writer == null) {
                this.stream = this.response.getOutputStream();
            }
            return this.stream;
        }

        public void commitOutput() throws IOException {
            ServletOutputStream os = this.response.getOutputStream();
            InputStream is = this.getInputStream();
            if (is != null) {
                Utils.transferContent(is, (OutputStream)os);
            }
            os.flush();
        }

        public InputStream getInputStream() {
            if (this.writer != null) {
                try {
                    return new ByteArrayInputStream(this.writer.toString().getBytes(this.getCharacterEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public String getString() {
            if (this.writer != null) {
                return this.writer.toString();
            }
            return null;
        }
    }
}

