/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum R4EDecision implements Enumerator
{
    R4E_REVIEW_DECISION_NONE(0, "R4E_REVIEW_DECISION_NONE", "R4E_REVIEW_DECISION_NONE"),
    R4E_REVIEW_DECISION_ACCEPTED(1, "R4E_REVIEW_DECISION_ACCEPTED", "R4E_REVIEW_DECISION_ACCEPTED"),
    R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP(2, "R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP", "R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP"),
    R4E_REVIEW_DECISION_REJECTED(3, "R4E_REVIEW_DECISION_REJECTED", "R4E_REVIEW_DECISION_REJECTED");

    public static final int R4E_REVIEW_DECISION_NONE_VALUE = 0;
    public static final int R4E_REVIEW_DECISION_ACCEPTED_VALUE = 1;
    public static final int R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP_VALUE = 2;
    public static final int R4E_REVIEW_DECISION_REJECTED_VALUE = 3;
    private static final R4EDecision[] VALUES_ARRAY;
    public static final List<R4EDecision> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new R4EDecision[]{R4E_REVIEW_DECISION_NONE, R4E_REVIEW_DECISION_ACCEPTED, R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP, R4E_REVIEW_DECISION_REJECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static R4EDecision get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EDecision result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EDecision getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EDecision result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EDecision get(int value) {
        switch (value) {
            case 0: {
                return R4E_REVIEW_DECISION_NONE;
            }
            case 1: {
                return R4E_REVIEW_DECISION_ACCEPTED;
            }
            case 2: {
                return R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP;
            }
            case 3: {
                return R4E_REVIEW_DECISION_REJECTED;
            }
        }
        return null;
    }

    private R4EDecision(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

