/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.ServiceHolder;
import org.eclipse.equinox.http.servlet.internal.registration.MatchableRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.osgi.dto.DTO;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;

public abstract class EndpointRegistration<D extends DTO>
extends MatchableRegistration<Servlet, D>
implements Comparable<EndpointRegistration<?>> {
    protected final ServiceHolder<Servlet> servletHolder;
    private final ServletContextHelper servletContextHelper;
    private final ContextController contextController;
    private final ClassLoader classLoader;
    private static final String SIMPLE_NAME = EndpointRegistration.class.getSimpleName();
    private String _toString;

    public EndpointRegistration(ServiceHolder<Servlet> servletHolder, D d, ServletContextHelper servletContextHelper, ContextController contextController) {
        super(servletHolder.get(), d);
        this.servletHolder = servletHolder;
        this.servletContextHelper = servletContextHelper;
        this.contextController = contextController;
        this.classLoader = servletHolder.getLegacyTCCL() != null ? servletHolder.getLegacyTCCL() : ((BundleWiring)servletHolder.getBundle().adapt(BundleWiring.class)).getClassLoader();
        this.createContextAttributes();
    }

    @Override
    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.contextController.getEndpointRegistrations().remove(this);
            this.contextController.getHttpServiceRuntime().getRegisteredObjects().remove(this.getT());
            this.contextController.ungetServletContextHelper(this.servletHolder.getBundle());
            super.destroy();
            ((Servlet)this.getT()).destroy();
        }
        finally {
            this.destroyContextAttributes();
            Thread.currentThread().setContextClassLoader(original);
            this.servletHolder.release();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EndpointRegistration)) {
            return false;
        }
        EndpointRegistration endpointRegistration = (EndpointRegistration)obj;
        return this.getD().equals(endpointRegistration.getD());
    }

    public int hashCode() {
        return this.getD().hashCode();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ((Servlet)this.getT()).init(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public abstract String getName();

    public abstract String[] getPatterns();

    public abstract long getServiceId();

    public ServletContext getServletContext() {
        return ((Servlet)this.getT()).getServletConfig().getServletContext();
    }

    public ServletContextHelper getServletContextHelper() {
        return this.servletContextHelper;
    }

    public abstract ServiceReference<?> getServiceReference();

    @Override
    public String match(String name, String servletPath, String pathInfo, String extension, Match match) {
        if (match == Match.ERROR) {
            return null;
        }
        if (name != null) {
            if (this.getName().equals(name)) {
                return name;
            }
            return null;
        }
        String[] patterns = this.getPatterns();
        if (patterns == null) {
            return null;
        }
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (this.doMatch(pattern, servletPath, pathInfo, extension, match)) {
                return pattern;
            }
            ++n2;
        }
        return null;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ((Servlet)this.getT()).service((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void createContextAttributes() {
        this.contextController.createContextAttributes();
    }

    private void destroyContextAttributes() {
        this.contextController.destroyContextAttributes();
    }

    @Override
    public int compareTo(EndpointRegistration<?> o) {
        int result = this.servletHolder.compareTo(o.servletHolder);
        if (result == 0) {
            result = Long.compare(this.getD().hashCode(), o.getD().hashCode());
        }
        return result;
    }

    @Override
    public String toString() {
        String toString = this._toString;
        if (toString == null) {
            this._toString = toString = String.valueOf(SIMPLE_NAME) + '[' + this.getD().toString() + ']';
        }
        return toString;
    }
}

