/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.acquire.GrantsTraceService;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.internal.base.access.Conduit;
import org.eclipse.passage.lic.internal.base.access.Residence;
import org.eclipse.passage.lic.internal.base.access.Storage;

public final class StoringGrantTraceService
implements GrantsTraceService {
    private final Residence residence;
    private final Storage storage;
    private final Conduit conduit;
    private volatile boolean fresh = true;

    public StoringGrantTraceService(Supplier<LicensedProduct> product, Supplier<Path> srotage, Supplier<LicenseAcquisitionServicesRegistry> acquirers) {
        this.residence = new Residence(srotage);
        this.storage = new Storage(this.residence.read());
        this.conduit = new Conduit(product, acquirers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void trace(GrantAcquisition grant) {
        Storage storage = this.storage;
        synchronized (storage) {
            if (this.fresh) {
                this.fresh = false;
                this.storage.forget(this.conduit.release(this.storage.grants()));
            }
            this.storage.keep(grant);
            this.residence.write(this.storage.grants());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forget(GrantAcquisition grant) {
        Storage storage = this.storage;
        synchronized (storage) {
            this.storage.forget(grant);
            this.residence.write(this.storage.grants());
        }
    }
}

