/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.ZonedDateTime;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.json.ConditionDeserializer;
import org.eclipse.passage.lic.internal.json.ConditionSerializer;
import org.eclipse.passage.lic.internal.json.RequirementSerializer;
import org.eclipse.passage.lic.internal.json.ZonedDateTimeDeserializer;
import org.eclipse.passage.lic.internal.json.ZonedDateTimeSerializer;

public final class JsonObjectMapper
implements Supplier<ObjectMapper> {
    @Override
    public ObjectMapper get() {
        return ((Function<ObjectMapper, ObjectMapper>)this::withVisibility).andThen(this::withFeatures).andThen(this::withSerializers).apply(new ObjectMapper());
    }

    private ObjectMapper withVisibility(ObjectMapper mapper) {
        return mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.ANY).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
    }

    private ObjectMapper withFeatures(ObjectMapper mapper) {
        return mapper.enable(SerializationFeature.INDENT_OUTPUT).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
    }

    private ObjectMapper withSerializers(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new ConditionSerializer(Condition.class));
        module.addDeserializer(Condition.class, (JsonDeserializer)new ConditionDeserializer(Condition.class));
        module.addSerializer((JsonSerializer)new RequirementSerializer(Requirement.class));
        module.addSerializer((JsonSerializer)new ZonedDateTimeSerializer(ZonedDateTime.class));
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer(ZonedDateTime.class));
        mapper.registerModule((Module)module);
        return mapper;
    }
}

