/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lbc.internal.api.Chore;
import org.eclipse.passage.lbc.internal.api.FloatingResponse;
import org.eclipse.passage.lbc.internal.api.RawRequest;
import org.eclipse.passage.lbc.internal.base.Failure;
import org.eclipse.passage.lbc.internal.base.ProductUserRequest;
import org.eclipse.passage.lbc.internal.base.ServerAuthentication;
import org.eclipse.passage.lbc.internal.base.ServerAuthenticationInstructions;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.EvaluationInstructions;

abstract class ChoreDraft
implements Chore {
    protected final RawRequest data;
    protected final Logger log = LogManager.getLogger(this.getClass());

    protected ChoreDraft(RawRequest request) {
        this.data = request;
    }

    public final FloatingResponse getDone() {
        ProductUserRequest request;
        Object instructions = new ServerAuthenticationInstructions(this.data).get();
        if (!((Optional)instructions).isPresent()) {
            return new Failure.BadRequestInvalidServerAuthInstructions();
        }
        try {
            new ServerAuthentication((EvaluationInstructions)((Optional)instructions).get()).evaluate();
        }
        catch (Exception e) {
            this.log.error("failed: ", (Throwable)e);
            return new Failure.ForeignServer(e.getMessage());
        }
        try {
            request = new ProductUserRequest(this.data);
        }
        catch (LicensingException e) {
            this.log.error("failed: ", (Throwable)e);
            return this.failed(e.getMessage());
        }
        if (!request.product().isPresent()) {
            return new Failure.BadRequestInvalidProduct();
        }
        if (!request.user().isPresent()) {
            return new Failure.BadRequestNoUser();
        }
        try {
            return this.withProductUser(request);
        }
        catch (LicensingException e) {
            this.log.error("failed: ", (Throwable)e);
            return this.failed(e.getMessage());
        }
    }

    protected abstract FloatingResponse withProductUser(ProductUserRequest var1) throws LicensingException;

    protected final FloatingResponse failed(String details) {
        return new Failure.OperationFailed(this.getClass().getSimpleName(), details);
    }
}

