/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.bc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.DigestExpectation;
import org.eclipse.passage.lic.bc.BcDigest;
import org.eclipse.passage.lic.internal.bc.i18n.BcMessages;

final class BcDecodedStream {
    private final LicensedProduct product;
    private final InputStream input;
    private final OutputStream output;

    BcDecodedStream(LicensedProduct product, InputStream input, OutputStream output) {
        this.product = product;
        this.input = input;
        this.output = output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void produce(InputStream publicKeyRing, DigestExpectation digest) throws LicensingException {
        byte[] ring = this.ring(publicKeyRing, digest);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream decodedInput = PGPUtil.getDecoderStream((InputStream)this.input);
                try {
                    block27: {
                        try (InputStream compressed = this.compressedData(decodedInput).getDataStream();){
                            JcaPGPObjectFactory factory = new JcaPGPObjectFactory(compressed);
                            PGPOnePassSignature signature = this.signature((PGPObjectFactory)factory);
                            Throwable throwable2 = null;
                            Object var11_16 = null;
                            try {
                                InputStream literal = this.literalDataStream((PGPObjectFactory)factory);
                                try {
                                    try (InputStream decoder = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(ring));){
                                        PGPPublicKey decodeKey = this.decodeKey(new BcPGPPublicKeyRingCollection(decoder), signature.getKeyID());
                                        signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider(), decodeKey);
                                        this.writeVerifiedDecodedOutput(literal, signature, (PGPObjectFactory)factory);
                                    }
                                    if (literal == null) break block27;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    if (literal == null) throw throwable2;
                                    literal.close();
                                    throw throwable2;
                                }
                                literal.close();
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                                throw throwable2;
                            }
                        }
                    }
                    if (decodedInput == null) return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (decodedInput == null) throw throwable;
                    decodedInput.close();
                    throw throwable;
                }
                decodedInput.close();
                return;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new LicensingException(String.format(BcMessages.getString("BcStreamCodec_deconde_error"), this.product), (Throwable)e);
        }
    }

    private void writeVerifiedDecodedOutput(InputStream literal, PGPOnePassSignature signature, PGPObjectFactory factory) throws Exception {
        int ch;
        ByteArrayOutputStream untrusted = new ByteArrayOutputStream();
        while ((ch = literal.read()) >= 0) {
            signature.update((byte)ch);
            untrusted.write(ch);
        }
        if (signature.verify(this.pairSignature(factory))) {
            this.output.write(untrusted.toByteArray());
        }
    }

    private PGPPublicKey decodeKey(BcPGPPublicKeyRingCollection rings, long id) throws Exception {
        Optional<PGPPublicKey> key = Optional.ofNullable(rings.getPublicKey(id));
        if (!key.isPresent()) {
            throw new IOException(String.format(BcMessages.getString("BcStreamCodec_encode_error_public_key"), this.product));
        }
        return key.get();
    }

    private PGPOnePassSignature signature(PGPObjectFactory factory) throws IOException {
        return ((PGPOnePassSignatureList)factory.nextObject()).get(0);
    }

    private PGPSignature pairSignature(PGPObjectFactory factory) throws IOException {
        return ((PGPSignatureList)factory.nextObject()).get(0);
    }

    private InputStream literalDataStream(PGPObjectFactory factory) throws IOException {
        return ((PGPLiteralData)factory.nextObject()).getInputStream();
    }

    private PGPCompressedData compressedData(InputStream decoder) throws LicensingException, IOException {
        JcaPGPObjectFactory factory = new JcaPGPObjectFactory(decoder);
        Optional<PGPCompressedData> compressed = Optional.ofNullable((PGPCompressedData)factory.nextObject());
        if (!compressed.isPresent()) {
            throw new LicensingException(String.format(BcMessages.getString("BcStreamCodec_encode_error_data"), this.product));
        }
        return compressed.get();
    }

    private byte[] ring(InputStream publicKeyRing, DigestExpectation digest) throws LicensingException {
        byte[] ring = this.publicKeyRing(publicKeyRing);
        this.verifyKey(digest, ring);
        return ring;
    }

    private byte[] publicKeyRing(InputStream key) throws LicensingException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int chk;
                while ((chk = key.read()) >= 0) {
                    baos.write(chk);
                }
                return baos.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new LicensingException(String.format(BcMessages.getString("BcStreamCodec_encode_error_public_key"), this.product));
        }
    }

    private void verifyKey(DigestExpectation digest, byte[] key) throws LicensingException {
        if (!digest.expected()) {
            return;
        }
        if (Objects.deepEquals(new BcDigest(key).get(), digest.value())) {
            return;
        }
        throw new LicensingException(String.format(BcMessages.getString("BcStreamCodec_encode_error_digest"), this.product));
    }
}

