/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;

public final class JettyRequest
implements NetRequest {
    private final Request origin;
    private final Fields parameters;

    public JettyRequest(Request origin) {
        Objects.requireNonNull(origin, "JettyRequest::origin");
        this.origin = origin;
        this.parameters = Request.extractQueryParameters((Request)origin);
    }

    public String parameter(String name) {
        return this.parameters.getValue(name);
    }

    public byte[] content() throws IOException {
        byte[] content = new byte[(int)this.origin.getLength()];
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = Request.asInputStream((Request)this.origin);){
            stream.read(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return content;
    }
}

