/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IDecoratingObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.loc.internal.workbench.emfforms.i18n.WorkbenchEmfformsMessages;
import org.eclipse.passage.loc.workbench.dialogs.FileContentDialog;
import org.eclipse.passage.loc.workbench.emfforms.renderers.TextWithButtonRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class FileContentRenderer<O>
extends TextWithButtonRenderer {
    private static final String IDENTIFIER_EMPTY = "";
    private final Class<O> observedClass;

    @Inject
    public FileContentRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, Class<O> observed) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.observedClass = observed;
    }

    @Override
    protected Control createSWTControl(Composite parent) {
        Control control = super.createSWTControl(parent);
        this.button.setText(WorkbenchEmfformsMessages.FileContentRenderer_button_text);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileContentRenderer.this.showFileContent();
            }
        });
        return control;
    }

    @Override
    protected Button createButton(Composite parent) {
        Button created = super.createButton(parent);
        created.setEnabled(true);
        return created;
    }

    protected String getUnsetText() {
        return IDENTIFIER_EMPTY;
    }

    protected void showFileContent() {
        Shell shell = Display.getDefault().getActiveShell();
        String currentValue = this.getCurrentValue();
        String filePath = this.extractFilePath(currentValue);
        if (filePath == null) {
            String message = NLS.bind((String)WorkbenchEmfformsMessages.FileContentRenderer_e_content_title, (Object)currentValue);
            MessageDialog.openError((Shell)shell, (String)WorkbenchEmfformsMessages.FileContentRenderer_e_content_message, (String)message);
            return;
        }
        FileContentDialog dialog = new FileContentDialog(shell, filePath);
        dialog.open();
    }

    protected String extractFilePath(String currentValue) {
        try {
            IObserving ipo;
            Object source;
            IDecoratingObservable decorating;
            IObservable decorated;
            IObservableValue modelValue = this.getModelValue();
            if (modelValue instanceof IDecoratingObservable && (decorated = (decorating = (IDecoratingObservable)modelValue).getDecorated()) instanceof IObserving && this.observedClass.isInstance(source = (ipo = (IObserving)decorated).getObserved())) {
                return this.extractFilePath(currentValue, this.observedClass.cast(source));
            }
        }
        catch (DatabindingFailedException e) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)e));
        }
        return null;
    }

    protected abstract String extractFilePath(String var1, O var2);
}

