/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.emf.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.passage.lic.emf.QualifiedNames;
import org.eclipse.passage.lic.emf.SimpleQualifiedNames;

public final class DelegatingEFactory
extends EFactoryImpl {
    public final Map<String, EClass> eClassMap = new HashMap<String, EClass>();
    public final Map<String, EDataType> eDataTypeMap = new HashMap<String, EDataType>();
    public final Map<String, EFactory> eClassFactories = new HashMap<String, EFactory>();
    public final Map<String, EFactory> eDataTypeFactories = new HashMap<String, EFactory>();
    private final QualifiedNames names = new SimpleQualifiedNames();

    DelegatingEFactory() {
    }

    public void delegateEClass(EFactory factory, EClass from, EClass to) {
        String key = this.names.caseEClass(from);
        this.eClassFactories.put(key, factory);
        this.eClassMap.put(key, to);
    }

    public void delegateEDataType(EFactory factory, EDataType from, EDataType to) {
        String key = this.names.caseEDataType(from);
        this.eDataTypeFactories.put(key, factory);
        this.eDataTypeMap.put(key, to);
    }

    public EObject create(EClass eClass) {
        EFactory factory = this.resolveDelegate(eClass);
        EClass resolved = this.resolveEClass(eClass);
        if (factory != null && resolved != null) {
            return factory.create(resolved);
        }
        return super.create(eClass);
    }

    public Object createFromString(EDataType eDataType, String stringValue) {
        EFactory factory = this.resolveDelegate(eDataType);
        EDataType resolved = this.resolveEDataType(eDataType);
        if (factory != null && resolved != null) {
            return factory.createFromString(resolved, stringValue);
        }
        return super.createFromString(eDataType, stringValue);
    }

    public String convertToString(EDataType eDataType, Object objectValue) {
        EFactory factory = this.resolveDelegate(eDataType);
        EDataType resolved = this.resolveEDataType(eDataType);
        if (factory != null && resolved != null) {
            return factory.convertToString(resolved, objectValue);
        }
        return super.convertToString(eDataType, objectValue);
    }

    private EFactory resolveDelegate(EClass eClass) {
        return this.eClassFactories.get(this.names.caseEClass(eClass));
    }

    private EFactory resolveDelegate(EDataType eDataType) {
        return this.eDataTypeFactories.get(this.names.caseEDataType(eDataType));
    }

    private EClass resolveEClass(EClass eClass) {
        return this.eClassMap.get(this.names.caseEClass(eClass));
    }

    private EDataType resolveEDataType(EDataType eDataType) {
        return this.eDataTypeMap.get(this.names.caseEDataType(eDataType));
    }
}

