/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc.remote.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.base.diagnostic.code.AbsentLicenseAttendantFile;
import org.eclipse.passage.lic.base.io.LicensingFolder;
import org.eclipse.passage.lic.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.base.io.UserHomePath;
import org.eclipse.passage.lic.hc.remote.Client;
import org.eclipse.passage.lic.hc.remote.Connection;
import org.eclipse.passage.lic.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.hc.remote.impl.AccessPacks;
import org.eclipse.passage.lic.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.hc.remote.impl.RemoteRequest;
import org.eclipse.passage.lic.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;

public abstract class ServiceRemote<C extends Connection, T, D extends RemoteServiceData> {
    protected final Equipment equipment;
    private final Supplier<Path> source;
    private final Supplier<Client<C, T>> client;

    protected ServiceRemote(Equipment equipment, Supplier<Client<C, T>> client, Supplier<Path> source) {
        this.equipment = equipment;
        this.source = source;
        this.client = client;
    }

    protected ServiceRemote(Equipment equipment, Supplier<Client<C, T>> client) {
        this(equipment, client, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    public final ServiceInvocationResult<T> request(D parameters) {
        ServiceInvocationResult<Collection<FloatingLicenseAccess>> accesses = this.accesses(((RemoteServiceData)parameters).product());
        if (!new NoSevereErrors().test(accesses.diagnostic())) {
            return new BaseServiceInvocationResult(accesses.diagnostic());
        }
        if (((Collection)accesses.data().get()).isEmpty()) {
            return this.noServers(((RemoteServiceData)parameters).product());
        }
        return this.withServers(parameters, (Collection)accesses.data().get());
    }

    protected final ServiceInvocationResult<T> withServer(D params, FloatingLicenseAccess access) {
        return this.client.get().request(this.request(params, access), this.handler(access));
    }

    private ServiceInvocationResult<T> noServers(LicensedProduct product) {
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.singletonList(new Trouble((TroubleCode)new AbsentLicenseAttendantFile(), String.format(AccessMessages.RemoteService_no_server, new PathFromLicensedProduct(this.source, product).get().toAbsolutePath())))));
    }

    private ServiceInvocationResult<Collection<FloatingLicenseAccess>> accesses(LicensedProduct product) {
        return new AccessPacks(product, this.equipment.keys(), this.equipment.codecs(), this.source).get();
    }

    protected abstract ServiceInvocationResult<T> withServers(D var1, Collection<FloatingLicenseAccess> var2);

    protected abstract RemoteRequest<C> request(D var1, FloatingLicenseAccess var2);

    protected abstract ResponseHandler<T> handler(FloatingLicenseAccess var1);
}

