/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.emf.validation;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.passage.lic.internal.emf.i18n.EmfMessages;

public final class ErrorMessages
implements Function<EObject, Optional<String>> {
    @Override
    public Optional<String> apply(EObject input) {
        if (input == null) {
            return Optional.of(EmfMessages.LicensingEcore_input_invalid);
        }
        Diagnostic result = Diagnostician.INSTANCE.validate(input);
        if (result.getSeverity() == 0) {
            return Optional.empty();
        }
        int errorCount = result.getChildren().size();
        String header = EmfMessages.LicensingEcore_inpur_header;
        String entry = EmfMessages.LicensingEcore_input_entry;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(header, errorCount));
        sb.append('\n');
        int messageCount = 0;
        for (Diagnostic d : result.getChildren()) {
            sb.append('\n');
            sb.append(String.format(entry, ++messageCount, d.getMessage()));
        }
        return Optional.of(sb.toString());
    }
}

