/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.emfforms.renderers;

import java.util.Optional;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.eclipse.passage.loc.internal.workbench.emfforms.renderers.ExtendedMultiReferenceSWTRenderer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class ExtendedMultiReferenceSWTRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabinding databinding;
    private ReportService report;

    @Reference
    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databinding = databindingService;
    }

    @Reference
    protected void setReportService(ReportService reportService) {
        this.report = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext context) {
        IValueProperty property;
        Optional<VDomainModelReference> dmr = this.dmr(vElement);
        if (dmr.isEmpty()) {
            return Double.NaN;
        }
        try {
            property = this.databinding.getValueProperty(dmr.get(), context.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.report.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        EStructuralFeature feature = (EStructuralFeature)EStructuralFeature.class.cast(property.getValueType());
        if (!feature.isMany() || !EReference.class.isInstance(feature)) {
            return Double.NaN;
        }
        return 20.0;
    }

    private Optional<VDomainModelReference> dmr(VElement element) {
        return Optional.ofNullable(element).filter(VControl.class::isInstance).map(VControl.class::cast).map(VControl::getDomainModelReference);
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return ExtendedMultiReferenceSWTRenderer.class;
    }
}

