/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.equinox.BundleResource;
import org.eclipse.passage.lic.internal.equinox.i18n.AccessMessages;
import org.osgi.framework.Bundle;

final class BundleManifest {
    private final Bundle bundle;
    private final Path midpath = Paths.get("META-INF", new String[0]).resolve("MANIFEST.MF");

    public BundleManifest(Bundle bundle) {
        Objects.requireNonNull(bundle, "BundleManifest::bundle");
        this.bundle = bundle;
    }

    public String get() throws LicensingException {
        Object url = new BundleResource(this.bundle, this.midpath).get();
        if (!((Optional)url).isPresent()) {
            throw this.noManifest();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(((URL)((Optional)url).get()).openStream()));){
                return reader.lines().collect(Collectors.joining("\n"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw this.errorOnReading(e);
        }
    }

    private LicensingException errorOnReading(IOException e) {
        return new LicensingException(String.format(AccessMessages.RequirementsFromManifest_reading_error, e));
    }

    private LicensingException noManifest() {
        return new LicensingException(String.format(AccessMessages.RequirementsFromManifest_no_manifest, this.midpath, this.bundle.getSymbolicName()));
    }
}

