/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.io;

import java.util.Base64;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.Hashes;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.base.io.KeyContent;
import org.eclipse.passage.lic.internal.net.io.SymmetricCode;

public final class SafePayload {
    private final Hashes hashes;
    private final KeyKeeper keeper;

    public SafePayload(KeyKeeper keeper, Hashes hashes) {
        this.keeper = keeper;
        this.hashes = hashes;
    }

    public byte[] encode(byte[] raw) throws LicensingException {
        return this.transportable(this.coded(raw));
    }

    public byte[] decode(byte[] raw) throws LicensingException {
        return this.coded(this.transported(raw));
    }

    private byte[] transportable(byte[] content) {
        return Base64.getEncoder().encode(content);
    }

    private byte[] transported(byte[] content) {
        return Base64.getDecoder().decode(content);
    }

    private byte[] coded(byte[] source) throws LicensingException {
        return new SymmetricCode(this.key()).get(source);
    }

    private byte[] key() throws LicensingException {
        return this.hashes.get(new KeyContent(this.keeper).get());
    }
}

