/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.SumOfDiagnostics;

public final class BaseServiceInvocationResult<T>
implements ServiceInvocationResult<T> {
    private final Diagnostic diagnostic;
    private final Optional<T> data;

    public BaseServiceInvocationResult(Trouble severe) {
        this((Diagnostic)new BaseDiagnostic(severe), Optional.empty());
    }

    public BaseServiceInvocationResult(T data) {
        this((Diagnostic)new BaseDiagnostic(), Optional.of(data));
    }

    public BaseServiceInvocationResult(Diagnostic diagnostic) {
        this(diagnostic, Optional.empty());
    }

    public BaseServiceInvocationResult(Diagnostic diagnostic, T data) {
        this(diagnostic, Optional.of(data));
    }

    public BaseServiceInvocationResult(Diagnostic diagnostic, Optional<T> data) {
        Objects.requireNonNull(diagnostic, "BaseServiceInvocationResult:diagnostic");
        Objects.requireNonNull(data, "BaseServiceInvocationResult:data");
        this.diagnostic = diagnostic;
        this.data = data;
    }

    public Diagnostic diagnostic() {
        return this.diagnostic;
    }

    public Optional<T> data() {
        return this.data;
    }

    public static final class Sum<T>
    implements BinaryOperator<ServiceInvocationResult<T>> {
        private final BinaryOperator<T> sum;

        public Sum(BinaryOperator<T> sum) {
            this.sum = sum;
        }

        @Override
        public ServiceInvocationResult<T> apply(ServiceInvocationResult<T> first, ServiceInvocationResult<T> second) {
            return new BaseServiceInvocationResult<T>(new SumOfDiagnostics().apply(first.diagnostic(), second.diagnostic()), this.sum(first.data(), second.data()));
        }

        private Optional<T> sum(Optional<T> first, Optional<T> second) {
            if (first.isPresent() && second.isPresent()) {
                return Optional.of(this.sum.apply(first.get(), second.get()));
            }
            if (first.isPresent()) {
                return first;
            }
            if (second.isPresent()) {
                return second;
            }
            return Optional.empty();
        }
    }
}

