/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.features.core;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.features.FeatureDescriptor;
import org.eclipse.passage.lic.features.FeatureSetDescriptor;
import org.eclipse.passage.lic.features.FeatureVersionDescriptor;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.equinox.io.InstallationPath;
import org.eclipse.passage.loc.internal.emf.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.internal.features.core.FeaturesDomainRegistryTracker;
import org.eclipse.passage.loc.internal.features.core.i18n.FeaturesCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=features", "org.eclipse.passage.lic.emf.edit.file.extension=features_xmi"})
public class FeatureDomainRegistry
extends BaseDomainRegistry<FeatureSetDescriptor>
implements FeatureRegistry,
EditingDomainRegistry<FeatureSetDescriptor> {
    private final Map<String, FeatureSetDescriptor> featureSetIndex = new HashMap<String, FeatureSetDescriptor>();
    private final Map<String, FeatureDescriptor> featureIndex = new HashMap<String, FeatureDescriptor>();
    private final Map<String, Map<String, FeatureVersionDescriptor>> featureVersionIndex = new HashMap<String, Map<String, FeatureVersionDescriptor>>();
    private EventAdmin events;

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events = null;
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        Collection<Map<String, FeatureVersionDescriptor>> values = this.featureVersionIndex.values();
        for (Map<String, FeatureVersionDescriptor> map : values) {
            map.clear();
        }
        this.featureVersionIndex.clear();
        this.featureIndex.clear();
        this.featureSetIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "features_xmi";
    }

    public Class<FeatureSetDescriptor> getContentClass() {
        return FeatureSetDescriptor.class;
    }

    public String resolveIdentifier(FeatureSetDescriptor content) {
        return content.getIdentifier();
    }

    @Override
    public Iterable<? extends FeatureSetDescriptor> getFeatureSets() {
        return new ArrayList<FeatureSetDescriptor>(this.featureSetIndex.values());
    }

    @Override
    public FeatureSetDescriptor getFeatureSet(String identifier) {
        return this.featureSetIndex.get(identifier);
    }

    @Override
    public Iterable<? extends FeatureDescriptor> getFeatures() {
        return new ArrayList<FeatureDescriptor>(this.featureIndex.values());
    }

    @Override
    public Iterable<? extends FeatureDescriptor> getFeatures(String featureSetId) {
        FeatureSetDescriptor featureSet = this.featureSetIndex.get(featureSetId);
        if (featureSet == null) {
            return Collections.emptyList();
        }
        ArrayList features = new ArrayList();
        featureSet.getFeatures().forEach(features::add);
        return features;
    }

    @Override
    public FeatureDescriptor getFeature(String identifier) {
        return this.featureIndex.get(identifier);
    }

    @Override
    public Iterable<? extends FeatureVersionDescriptor> getFeatureVersions() {
        ArrayList<FeatureVersionDescriptor> list = new ArrayList<FeatureVersionDescriptor>();
        Collection<Map<String, FeatureVersionDescriptor>> values = this.featureVersionIndex.values();
        for (Map<String, FeatureVersionDescriptor> map : values) {
            list.addAll(map.values());
        }
        return list;
    }

    @Override
    public Iterable<? extends FeatureVersionDescriptor> getFeatureVersions(String featureId) {
        Map<String, FeatureVersionDescriptor> map = this.featureVersionIndex.get(featureId);
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<FeatureVersionDescriptor>(map.values());
    }

    @Override
    public FeatureVersionDescriptor getFeatureVersion(String featureId, String version) {
        Map<String, FeatureVersionDescriptor> map = this.featureVersionIndex.get(featureId);
        if (map == null) {
            return null;
        }
        return map.get(version);
    }

    protected DomainContentAdapter<FeatureSetDescriptor, FeatureDomainRegistry> createContentAdapter() {
        return new FeaturesDomainRegistryTracker(this);
    }

    @Override
    public void registerFeatureSet(FeatureSetDescriptor featureSet) {
        String identifier = featureSet.getIdentifier();
        FeatureSetDescriptor existing = this.featureSetIndex.put(identifier, featureSet);
        if (existing != null) {
            String msg = NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)featureSet);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureSet/create", (Object)featureSet).get());
        Iterable features = featureSet.getFeatures();
        for (FeatureDescriptor feature : features) {
            this.registerFeature(feature);
        }
    }

    @Override
    public void registerFeature(FeatureDescriptor feature) {
        String identifier = feature.getIdentifier();
        FeatureDescriptor existing = this.featureIndex.put(identifier, feature);
        if (existing != null) {
            String msg = NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)feature);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/Feature/create", (Object)feature).get());
        Iterable featureVersions = feature.getFeatureVersions();
        for (FeatureVersionDescriptor featureVersion : featureVersions) {
            this.registerFeatureVersion(feature, featureVersion);
        }
    }

    @Override
    public void registerFeatureVersion(FeatureDescriptor feature, FeatureVersionDescriptor featureVersion) {
        String version;
        String identifier = feature.getIdentifier();
        Map map = this.featureVersionIndex.computeIfAbsent(identifier, key -> new HashMap());
        FeatureVersionDescriptor existing = map.put(version = featureVersion.getVersion(), featureVersion);
        if (existing != null) {
            String msg = NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)featureVersion);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureVersion/create", (Object)featureVersion).get());
    }

    @Override
    public void unregisterFeatureSet(String featureSetId) {
        FeatureSetDescriptor removed = this.featureSetIndex.remove(featureSetId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureSet/delete", (Object)removed).get());
            Iterable features = removed.getFeatures();
            for (FeatureDescriptor feature : features) {
                this.unregisterFeature(feature.getIdentifier());
            }
        }
    }

    @Override
    public void unregisterFeature(String featureId) {
        FeatureDescriptor removed = this.featureIndex.remove(featureId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/Feature/delete", (Object)removed).get());
            Iterable featureVersions = removed.getFeatureVersions();
            for (FeatureVersionDescriptor featureVersion : featureVersions) {
                this.unregisterFeatureVersion(featureId, featureVersion.getVersion());
            }
        }
    }

    @Override
    public void unregisterFeatureVersion(String featureId, String version) {
        Map<String, FeatureVersionDescriptor> map = this.featureVersionIndex.get(featureId);
        if (map != null) {
            FeatureVersionDescriptor removed = map.remove(version);
            if (removed != null) {
                this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureVersion/delete", (Object)removed).get());
            }
            if (map.isEmpty()) {
                this.featureVersionIndex.remove(version);
            }
        }
    }

    public EClass getContentClassifier() {
        return FeaturesPackage.eINSTANCE.getFeatureSet();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return FeaturesPackage.eINSTANCE.getFeatureSet_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return FeaturesPackage.eINSTANCE.getFeatureSet_Name();
    }

    public void registerContent(FeatureSetDescriptor content) {
        this.registerFeatureSet(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterFeatureSet(identifier);
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = new InstallationPath().get();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        return passagePath.resolve(this.domainName);
    }
}

