/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.api.conditions.evaluation;

import java.util.Objects;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;

public abstract class ExpressionProtocol
implements ServiceId {
    private final String identifier;

    protected ExpressionProtocol(String identifier) {
        Objects.requireNonNull(identifier, "ExpressionProtocol::identifier");
        this.identifier = identifier.trim().toLowerCase();
    }

    public final String identifier() {
        return this.identifier;
    }

    public final int hashCode() {
        return Objects.hash(this.identifier());
    }

    public final boolean equals(Object object) {
        if (!ExpressionProtocol.class.isInstance(object)) {
            return false;
        }
        return this.identifier.equals(((ExpressionProtocol)object).identifier);
    }

    public final String toString() {
        return this.identifier;
    }

    public static final class Berlin
    extends ExpressionProtocol {
        public Berlin() {
            super("berlin");
        }
    }

    public static final class Default
    extends ExpressionProtocol {
        public Default() {
            super(new Berlin().identifier());
        }
    }

    public static final class Munich
    extends ExpressionProtocol {
        public Munich() {
            super("munich");
        }
    }

    public static final class Of
    extends ExpressionProtocol {
        public Of(String identifier) {
            super(identifier);
        }
    }
}

