/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnInfrastructureDenial;
import org.eclipse.passage.lic.internal.hc.i18n.HcMessages;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Request;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;

public final class HttpClient
implements Client<HttpURLConnection> {
    @Override
    public ServiceInvocationResult<Collection<ConditionPack>> remoteConditions(Request<HttpURLConnection> request, ResponseHandler miner) {
        try {
            return new BaseServiceInvocationResult(this.netConditions(this.connection(request), miner));
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceFailedOnInfrastructureDenial(), HcMessages.HttpClient_final_error_message, e));
        }
    }

    private HttpURLConnection connection(Request<HttpURLConnection> request) throws Exception {
        return request.config().apply((HttpURLConnection)request.url().openConnection());
    }

    private Collection<ConditionPack> netConditions(HttpURLConnection connection, ResponseHandler miner) throws Exception {
        if (connection.getResponseCode() != 200) {
            connection.getInputStream().close();
            throw new RuntimeException(String.format(HcMessages.HttpClient_not_ok_response, connection.getResponseCode(), connection.getResponseMessage()));
        }
        return this.read(connection, miner);
    }

    private Collection<ConditionPack> read(HttpURLConnection connection, ResponseHandler miner) throws Exception {
        byte[] content = new byte[connection.getContentLength()];
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream source = connection.getInputStream();){
            source.read(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return miner.read(content, connection.getHeaderField("Content-Type"));
    }
}

