/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.parts;

import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultDeleteActionBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DeleteActionBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.MenuProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailMenuListener;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTFactory;
import org.eclipse.emfforms.spi.swt.treemasterdetail.actions.ActionCollector;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.passage.lic.emf.ecore.LicensingEcore;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.loc.internal.workbench.emfforms.i18n.WorkbenchEmfformsMessages;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.passage.loc.workbench.viewers.DomainRegistryLabelProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class DetailsView {
    private final MPart part;
    private Composite content;
    private EObject root;
    private final CommandStackListener dirtyStackListener;
    private final ISelectionChangedListener selectionChangedListener;
    private CommandStack commandStack;

    @Inject
    public DetailsView(MPart part, ESelectionService selectionService) {
        this.part = part;
        this.dirtyStackListener = e -> {
            Object source = e.getSource();
            if (source instanceof BasicCommandStack) {
                BasicCommandStack stack = (BasicCommandStack)source;
                part.setDirty(stack.isSaveNeeded());
            }
        };
        this.selectionChangedListener = e -> {
            ISelection selection = e.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                selectionService.setSelection(structured.getFirstElement());
            }
        };
    }

    @PostConstruct
    public void createComposite(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setBackground(parent.getDisplay().getSystemColor(1));
        this.content.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).create());
        this.content.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    @Inject
    @Optional
    protected void subscribeTopicShow(@UIEventTopic(value="org/eclipse/passage/loc/workbench/show") Notifier input, IEclipseContext context) {
        this.show(input, context);
    }

    protected void show(Notifier input, IEclipseContext context) {
        Control[] children;
        if (this.content == null || this.content.isDisposed()) {
            return;
        }
        if (input == null) {
            return;
        }
        this.root = LicensingEcore.extractEObject((Object)input);
        Resource resource = LicensingEcore.extractResource((Object)input);
        this.configurePart(resource, context);
        Control[] controlArray = children = this.content.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.root != null) {
            try {
                TreeMasterDetailComposite rootView = this.createRootView(this.content, resource, this.getCreateElementCallback(), context);
                TreeViewer selectionProvider = rootView.getSelectionProvider();
                selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
                selectionProvider.refresh();
                EObject objectToReveal = this.root;
                while (objectToReveal != null) {
                    selectionProvider.reveal((Object)objectToReveal);
                    if (selectionProvider.testFindItem((Object)objectToReveal) != null) break;
                    objectToReveal = objectToReveal.eContainer();
                }
                if (objectToReveal == null) {
                    return;
                }
                rootView.setSelection((ISelection)new StructuredSelection((Object)objectToReveal));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.content.layout();
    }

    protected TreeMasterDetailComposite createRootView(Composite parent, Object editorInput, CreateElementCallback createElementCallback, IEclipseContext context) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        composite.setLayout((Layout)new FormLayout());
        FormData treeMasterDetailLayoutData = new FormData();
        treeMasterDetailLayoutData.top = new FormAttachment(0);
        treeMasterDetailLayoutData.left = new FormAttachment(0);
        treeMasterDetailLayoutData.right = new FormAttachment(100);
        treeMasterDetailLayoutData.bottom = new FormAttachment(100);
        TreeMasterDetailComposite treeMasterDetail = this.createTreeMasterDetail(composite, editorInput, createElementCallback);
        treeMasterDetail.setLayoutData((Object)treeMasterDetailLayoutData);
        TreeViewer selectionProvider = treeMasterDetail.getSelectionProvider();
        ComposedAdapterFactory adapterFactory = ((ComposedAdapterFactoryProvider)context.get(ComposedAdapterFactoryProvider.class)).getComposedAdapterFactory();
        selectionProvider.setLabelProvider((IBaseLabelProvider)new DomainRegistryLabelProvider((AdapterFactory)adapterFactory));
        return treeMasterDetail;
    }

    protected TreeMasterDetailComposite createTreeMasterDetail(Composite composite, Object editorInput, CreateElementCallback createElementCallback) {
        ChildrenDescriptorCollector childrenDescriptorCollector = this.createChildrenDescriptorCollector();
        MenuProvider menuProvider = this.createMenuProvider(childrenDescriptorCollector, createElementCallback);
        TreeMasterDetailComposite treeMasterDetail = TreeMasterDetailSWTFactory.fillDefaults((Composite)composite, (int)0, (Object)editorInput).customizeCildCreation(createElementCallback).customizeMenu(menuProvider).create();
        return treeMasterDetail;
    }

    protected MenuProvider createMenuProvider(final ChildrenDescriptorCollector childrenDescriptorCollector, final CreateElementCallback createElementCallback) {
        MenuProvider menuProvider = new MenuProvider(){

            public Menu getMenu(TreeViewer treeViewer, EditingDomain editingDomain) {
                MenuManager menuMgr = new MenuManager();
                menuMgr.setRemoveAllWhenShown(true);
                List masterDetailActions = ActionCollector.newList().addCutAction(editingDomain).addCopyAction(editingDomain).addPasteAction(editingDomain).getList();
                menuMgr.addMenuListener((IMenuListener)new TreeMasterDetailMenuListener(childrenDescriptorCollector, menuMgr, treeViewer, editingDomain, (Collection)masterDetailActions, createElementCallback, (DeleteActionBuilder)new DefaultDeleteActionBuilder()));
                Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
                return menu;
            }
        };
        return menuProvider;
    }

    protected void configurePart(Resource resource, IEclipseContext context) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)LicensingEcore.extractEObject((Object)resource));
        context.set(EditingDomain.class, (Object)editingDomain);
        if (editingDomain instanceof AdapterFactoryEditingDomain) {
            AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            context.set(AdapterFactory.class, (Object)adapterFactory);
            if (this.commandStack == null) {
                this.commandStack = editingDomain.getCommandStack();
                this.commandStack.addCommandStackListener(this.dirtyStackListener);
            }
            this.commandStack.flush();
        }
        if (resource != null) {
            URI uri = resource.getURI();
            if (uri != null) {
                this.part.setLabel(uri.lastSegment());
                this.part.setTooltip(String.valueOf(uri));
            }
        } else {
            this.part.setLabel(WorkbenchEmfformsMessages.DetailsView_label_details);
        }
    }

    @PreDestroy
    public void dispose() {
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackListener(this.dirtyStackListener);
        }
    }

    @Persist
    public void save() {
        IStatus status;
        if (this.root == null) {
            this.part.setDirty(false);
            return;
        }
        Resource eResource = this.root.eResource();
        if (eResource != null && (status = LocWokbench.save((Resource)eResource)).isOK() && this.commandStack instanceof BasicCommandStack) {
            BasicCommandStack basicCommandStack = (BasicCommandStack)this.commandStack;
            basicCommandStack.saveIsDone();
            this.part.setDirty(basicCommandStack.isSaveNeeded());
        }
    }

    protected ChildrenDescriptorCollector createChildrenDescriptorCollector() {
        return new ChildrenDescriptorCollector();
    }

    protected CreateElementCallback getCreateElementCallback() {
        return null;
    }
}

