/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base;

import java.util.Objects;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.internal.base.NamedData;
import org.eclipse.passage.lic.internal.base.ProductIdentifier;
import org.eclipse.passage.lic.internal.base.ProductVersion;

public final class BaseLicensingConfiguration
implements LicensingConfiguration {
    private final String identifier;
    private final String version;

    public BaseLicensingConfiguration(String product, String version) {
        this.identifier = product;
        this.version = version;
    }

    public String getProductIdentifier() {
        return this.identifier;
    }

    public String getProductVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseLicensingConfiguration other = (BaseLicensingConfiguration)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        new NamedData.Writable<String>(new ProductIdentifier(this.identifier)).write(output);
        output.append(';');
        new NamedData.Writable<String>(new ProductVersion(this.version)).write(output);
        return output.toString();
    }
}

