/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.access;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.passage.lic.runtime.access.PermissionEmitter;
import org.eclipse.passage.lic.runtime.access.PermissionEmitterRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public class EquinoxPermissionEmitterRegistry
implements PermissionEmitterRegistry {
    private static final String NAME_UNDEFINED = "";
    private static final String DESCRIPTION_UNDEFINED = "";
    private final Map<String, String> conditionTypeNames = new HashMap<String, String>();
    private final Map<String, String> conditionTypeDescriptions = new HashMap<String, String>();
    private final Map<String, PermissionEmitter> permissionEmitters = new HashMap<String, PermissionEmitter>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindPermissionEmitter(PermissionEmitter emitter, Map<String, Object> properties) {
        Object conditionTypeDescription;
        Object conditionType = properties.get("licensing.condition.type.id");
        String type = String.valueOf(conditionType);
        this.permissionEmitters.put(type, emitter);
        Object conditionTypeName = properties.get("licensing.condition.type.name");
        if (conditionTypeName != null) {
            this.conditionTypeNames.put(type, String.valueOf(conditionTypeName));
        }
        if ((conditionTypeDescription = properties.get("licensing.condition.type.description")) != null) {
            this.conditionTypeDescriptions.put(type, String.valueOf(conditionTypeDescription));
        }
    }

    public void unbindPermissionEmitter(PermissionEmitter emitter, Map<String, Object> properties) {
        Object conditionType = properties.get("licensing.condition.type.id");
        String type = String.valueOf(conditionType);
        PermissionEmitter existing = this.permissionEmitters.remove(type);
        if (emitter == existing) {
            this.permissionEmitters.remove(type);
        }
    }

    public Iterable<String> getSupportedConditionTypes() {
        return Collections.unmodifiableSet(this.permissionEmitters.keySet());
    }

    public String getDefaultConditionType() {
        return "<undefined>";
    }

    public PermissionEmitter getPermissionEmitter(String conditionType) {
        return this.permissionEmitters.get(conditionType);
    }

    public Iterable<? extends PermissionEmitter> getPermissionEmitters() {
        return this.permissionEmitters.values();
    }

    public String getConditionTypeName(String conditionType) {
        String value = this.conditionTypeNames.get(conditionType);
        if (value != null) {
            return value;
        }
        return "";
    }

    public String getConditionTypeDescription(String conditionType) {
        String value = this.conditionTypeDescriptions.get(conditionType);
        if (value != null) {
            return value;
        }
        return "";
    }
}

