/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.emf.ecore;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;

public class LicensingEcore {
    public static String composeFullQualifiedName(EClass eClass) {
        if (eClass == null) {
            return null;
        }
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            return eClass.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ePackage.getNsPrefix()).append('.');
        sb.append(ePackage.getName()).append('.');
        sb.append(eClass.getName());
        return sb.toString();
    }

    public static String composeFullQualifiedName(EDataType eDataType) {
        if (eDataType == null) {
            return null;
        }
        EPackage ePackage = eDataType.getEPackage();
        if (ePackage == null) {
            return eDataType.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ePackage.getNsPrefix()).append('.');
        sb.append(ePackage.getName()).append('.');
        sb.append(eDataType.getName());
        return sb.toString();
    }

    public static EObject extractEObject(Object object) {
        Resource resource;
        EList contents;
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (object instanceof Resource && !(contents = (resource = (Resource)object).getContents()).isEmpty()) {
            return (EObject)contents.get(0);
        }
        return null;
    }

    public static Resource extractResource(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return eObject.eResource();
        }
        if (object instanceof Resource) {
            return (Resource)object;
        }
        return null;
    }

    public static String extractValidationError(EObject eObject) {
        if (eObject == null) {
            return "Input is invalid";
        }
        Diagnostic result = Diagnostician.INSTANCE.validate(eObject);
        if (result.getSeverity() == 0) {
            return null;
        }
        int errorCount = result.getChildren().size();
        String header = "%s error(s) occured while analyzing your inputs:";
        String entry = "%s. %s";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s error(s) occured while analyzing your inputs:", errorCount));
        sb.append('\n');
        int messageCount = 0;
        for (Diagnostic d : result.getChildren()) {
            sb.append('\n');
            sb.append(String.format("%s. %s", ++messageCount, d.getMessage()));
        }
        return sb.toString();
    }
}

