/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.internal.ui.UIPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class SetupPropertyTester
extends PropertyTester {
    public static final String PREFIX = "org.eclipse.oomph.setup.ui.";
    public static final String STARTING = "starting";
    public static final String PERFORMING = "performing";
    public static final String HANDLING = "handling";
    public static final String SYNC_ENABLED = "syncEnabled";
    public static final String SHOW_TOOL_BAR_CONTRIBUTIONS = "showToolBarContributions";
    public static final String SHOW_PROGRESS_IN_WIZARD = "showProgressInWizard";
    public static final String DONATING = "donating";
    public static final String PROBLEM = "problem";
    public static final String NOTIFICATIONS = "notifications";
    private static final Preferences PREFERENCES = SetupUIPlugin.INSTANCE.getInstancePreferences();
    private static boolean starting;
    private static IStatus performingStatus;
    private static Shell performingShell;
    private static Shell handlingShell;
    private static boolean started;
    private static String donating;
    private static String problem;
    private static final List<Annotation> notifications;

    static {
        notifications = new ArrayList<Annotation>();
        ((IEclipsePreferences)PREFERENCES).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (SetupPropertyTester.SHOW_TOOL_BAR_CONTRIBUTIONS.equals(event.getKey())) {
                    UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.showToolBarContributions", (boolean)"true".equals(event.getNewValue()));
                }
            }
        });
        UIUtil.timerExec((int)2000, (Runnable)new Runnable(){

            @Override
            public void run() {
                UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.showToolBarContributions", (boolean)true);
            }
        });
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (STARTING.equals(property)) {
            return this.testStarting(receiver, args, expectedValue);
        }
        if (PERFORMING.equals(property)) {
            return this.testPerforming(receiver, args, expectedValue);
        }
        if (HANDLING.equals(property)) {
            return this.testHandling(receiver, args, expectedValue);
        }
        if (SYNC_ENABLED.equals(property)) {
            return this.testSyncEnabled(receiver, args, expectedValue);
        }
        if (SHOW_TOOL_BAR_CONTRIBUTIONS.equals(property)) {
            return this.testShowToolBarContributions(receiver, args, expectedValue);
        }
        if (DONATING.equals(property)) {
            return this.testDonating(receiver, args, expectedValue);
        }
        if (PROBLEM.equals(property)) {
            return this.testProblem(receiver, args, expectedValue);
        }
        return false;
    }

    private boolean testStarting(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(starting);
    }

    private boolean testPerforming(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(performingShell != null);
    }

    private boolean testHandling(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(handlingShell != null);
    }

    private boolean testSyncEnabled(Object receiver, Object[] args, Object expectedValue) {
        if (!started) {
            return false;
        }
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(SynchronizerManager.INSTANCE.isSyncEnabled());
    }

    private boolean testShowToolBarContributions(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        boolean value = PREFERENCES.getBoolean(SHOW_TOOL_BAR_CONTRIBUTIONS, false);
        return expectedValue.equals(value);
    }

    private boolean testDonating(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(donating != null);
    }

    private boolean testProblem(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(problem != null);
    }

    public static void setStarting(boolean starting) {
        if (!starting) {
            started = true;
            UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.syncEnabled", (boolean)false);
        }
        SetupPropertyTester.starting = starting;
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.starting", (boolean)false);
    }

    public static IStatus getPerformingStatus() {
        return performingStatus;
    }

    public static void setPerformingStatus(IStatus performingStatus) {
        SetupPropertyTester.performingStatus = performingStatus;
    }

    public static Shell getPerformingShell() {
        return performingShell;
    }

    public static void setPerformingShell(Shell shell) {
        performingShell = shell;
        if (shell != null) {
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SetupPropertyTester.setPerformingStatus(null);
                    SetupPropertyTester.setPerformingShell(null);
                }
            });
        }
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.performing", (shell != null ? 1 : 0) != 0);
    }

    public static Shell getHandlingShell() {
        return handlingShell;
    }

    public static void setHandlingShell(Shell shell) {
        handlingShell = shell;
        if (shell != null) {
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SetupPropertyTester.setHandlingShell(null);
                }
            });
        }
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.handling", (boolean)false);
    }

    public static String getDonating() {
        return donating;
    }

    public static void setDonating(String donating) {
        SetupPropertyTester.donating = donating;
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.donating", (boolean)false);
    }

    public static String getProblem() {
        return problem;
    }

    public static void setProblem(String problem) {
        SetupPropertyTester.problem = problem;
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.problem", (boolean)false);
    }

    public static boolean isShowProgressInWizard() {
        return PREFERENCES.getBoolean(SHOW_PROGRESS_IN_WIZARD, false);
    }

    public static List<Annotation> getNotifications() {
        return Collections.unmodifiableList(notifications);
    }

    public static void setNotifications(List<Annotation> notifications) {
        SetupPropertyTester.notifications.clear();
        SetupPropertyTester.notifications.addAll(EcoreUtil.copyAll(notifications));
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.notifications", (boolean)false);
    }
}

