/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.core.constants.Constants;

public class DBAccess {
    private static final Log LOGGER = LogFactory.getLog(DBAccess.class);
    private static DBAccess dbAccess = new DBAccess();
    private EntityManagerFactory emf;

    private DBAccess() {
    }

    public static DBAccess getInstance() {
        return dbAccess;
    }

    public static EntityManager createEntityManager() {
        return DBAccess.getInstance().emf.createEntityManager();
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public void init() {
        LOGGER.info((Object)"Intializing DataBase...");
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("javax.persistence.jdbc.driver", Constants.DB_DRIVER);
            properties.put("javax.persistence.jdbc.url", Constants.DB_URL);
            properties.put("javax.persistence.jdbc.user", Constants.DB_USER);
            properties.put("javax.persistence.jdbc.password", Constants.DB_PASSWORD);
            if (Constants.DB_RESET) {
                properties.put("eclipselink.ddl-generation", "drop-and-create-tables");
            } else {
                properties.put("eclipselink.ddl-generation", "create-or-extend-tables");
            }
            LOGGER.info((Object)"Creating new EntityManagerFactory...");
            this.emf = Persistence.createEntityManagerFactory((String)"om2mdb", properties);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in creation of EntityManagerFactory", (Throwable)e);
        }
        if (this.emf != null) {
            LOGGER.info((Object)"DataBase initialized.");
            EntityManager em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.close();
        } else {
            LOGGER.error((Object)"ERROR initializing Database: EntityManagerFactory is null!");
        }
    }
}

