/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.SclBase;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class SclBaseController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        SclBase sclBase = DAOFactory.getSclBaseDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (sclBase == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + "does not exist"));
        }
        errorResponse = this.checkAccessRight(sclBase.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        sclBase.setAccessRightsReference(String.valueOf(sclBase.getUri()) + "/accessRights");
        sclBase.setApplicationsReference(String.valueOf(sclBase.getUri()) + "/applications");
        sclBase.setContainersReference(String.valueOf(sclBase.getUri()) + "/containers");
        sclBase.setDiscoveryReference(String.valueOf(sclBase.getUri()) + "/discovery");
        sclBase.setGroupsReference(String.valueOf(sclBase.getUri()) + "/groups");
        sclBase.setSclsReference(String.valueOf(sclBase.getUri()) + "/scls");
        sclBase.setSubscriptionsReference(String.valueOf(sclBase.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)sclBase);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        SclBase sclBase = DAOFactory.getSclBaseDAO().find(requestIndication.getTargetID(), em);
        if (sclBase == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + "does not exist"));
        }
        errorResponse = this.checkAccessRight(sclBase.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        SclBase sclBaseNew = null;
        try {
            sclBaseNew = (SclBase)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (sclBaseNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (sclBaseNew.getSclsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "sclsReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getApplicationsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ApplicationsReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ContainersReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "GroupsReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AcessRightsReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionsReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getDiscoveryReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "DiscoveryReference UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time UPDATE is Not Permitted"));
        }
        if (sclBaseNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time UPDATE is Not Permitted"));
        }
        if (DAOFactory.getAccessRightDAO().find(sclBaseNew.getAccessRightID(), em) != null) {
            sclBase.setAccessRightID(sclBaseNew.getAccessRightID());
        }
        if (sclBaseNew.getSearchStrings() != null) {
            sclBase.setSearchStrings(sclBaseNew.getSearchStrings());
        }
        sclBase.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)sclBase);
        DAOFactory.getSclBaseDAO().update(sclBase, em);
        em.getTransaction().commit();
        em.close();
        sclBase.setAccessRightsReference(String.valueOf(sclBase.getUri()) + "/accessRights");
        sclBase.setApplicationsReference(String.valueOf(sclBase.getUri()) + "/applications");
        sclBase.setContainersReference(String.valueOf(sclBase.getUri()) + "/containers");
        sclBase.setDiscoveryReference(String.valueOf(sclBase.getUri()) + "/discovery");
        sclBase.setGroupsReference(String.valueOf(sclBase.getUri()) + "/groups");
        sclBase.setSclsReference(String.valueOf(sclBase.getUri()) + "/scls");
        sclBase.setSubscriptionsReference(String.valueOf(sclBase.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)sclBase);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not implemented"));
    }
}

