/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.Content;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.ContentInstances;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;

public class ContentController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, "Content CREATE method is not allowed"));
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        ContentInstance contentInstance = new ContentInstance();
        if (!requestIndication.getTargetID().contains("contentInstances")) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Bad URI: " + requestIndication.getTargetID()));
        }
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String contentInstancesURI = new String(String.valueOf(requestIndication.getTargetID().split("/contentInstances/")[0]) + "/contentInstances");
        ContentInstances contentInstances = DAOFactory.getContentInstancesDAO().find(contentInstancesURI, em);
        if (contentInstances == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(contentInstancesURI) + " does not exist"));
        }
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID().split("/contentInstances")[0], em);
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        String contentInstanceURI = String.valueOf(requestIndication.getTargetID().split("/contentInstances/")[0]) + "/contentInstances" + "/" + requestIndication.getTargetID().split("/contentInstances/")[1].split("/content")[0];
        contentInstance = DAOFactory.getContentInstanceDAO().find(contentInstanceURI, em);
        em.close();
        if (contentInstance == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(contentInstanceURI) + " does not exist"));
        }
        Content content = new Content();
        content.setValue(contentInstance.getContent());
        return new ResponseConfirm(StatusCode.STATUS_OK, new String(content.getValue().getValue()));
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, "Content UPDATE method is not allowed"));
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, "Content DELETE method is not allowed"));
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

