/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core;

import java.util.Date;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.comm.service.RestClientService;
import org.eclipse.om2m.commons.obix.io.ObixMapper;
import org.eclipse.om2m.commons.resource.AccessRight;
import org.eclipse.om2m.commons.resource.AnyURIList;
import org.eclipse.om2m.commons.resource.HolderRefListType;
import org.eclipse.om2m.commons.resource.MgmtProtocolType;
import org.eclipse.om2m.commons.resource.OnlineStatus;
import org.eclipse.om2m.commons.resource.PermissionFlagListType;
import org.eclipse.om2m.commons.resource.PermissionFlagType;
import org.eclipse.om2m.commons.resource.PermissionHolderType;
import org.eclipse.om2m.commons.resource.PermissionListType;
import org.eclipse.om2m.commons.resource.PermissionType;
import org.eclipse.om2m.commons.resource.Scl;
import org.eclipse.om2m.commons.resource.SclBase;
import org.eclipse.om2m.commons.resource.SearchStrings;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.constants.Constants;
import org.eclipse.om2m.core.controller.InterworkingProxyController;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.router.Router;
import org.eclipse.om2m.core.service.SclService;
import org.eclipse.om2m.ipu.service.IpuService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    private ServiceTracker<Object, Object> ipuServiceTracker;
    private ServiceTracker<Object, Object> restClientServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Starting SCL..");
        try {
            Activator.initScl();
        }
        catch (Exception e) {
            LOGGER.error((Object)"SCL is Stopped", (Throwable)e);
        }
        LOGGER.info((Object)"SCL Started.");
        LOGGER.info((Object)"Register SclService..");
        bundleContext.registerService(SclService.class.getName(), (Object)new Router(), null);
        LOGGER.info((Object)"SclService is registered.");
        this.ipuServiceTracker = new ServiceTracker<Object, Object>(bundleContext, IpuService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"IpuService removed");
                IpuService ipu = (IpuService)service;
                LOGGER.info((Object)("Remove IPU [ path = " + ipu.getAPOCPath() + " ]"));
                InterworkingProxyController.getIpUnits().remove(ipu.getAPOCPath());
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"IpuService discovered");
                IpuService ipu = (IpuService)this.context.getService(reference);
                LOGGER.info((Object)("Add IPU [ path = " + ipu.getAPOCPath() + " ]"));
                InterworkingProxyController.getIpUnits().put(ipu.getAPOCPath(), ipu);
                return ipu;
            }
        };
        this.ipuServiceTracker.open();
        this.restClientServiceTracker = new ServiceTracker<Object, Object>(bundleContext, RestClientService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"RestClientService removed");
                RestClientService restClient = (RestClientService)service;
                LOGGER.info((Object)("Remove RestClientService [ protocol = " + restClient.getProtocol() + " ]"));
                RestClient.getRestClients().remove(restClient.getProtocol());
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"RestClientService discovered");
                RestClientService sclClient = (RestClientService)this.context.getService(reference);
                LOGGER.info((Object)("Add RestClientService  [ protocol = " + sclClient.getProtocol() + " ]"));
                RestClient.getRestClients().put(sclClient.getProtocol(), sclClient);
                return sclClient;
            }
        };
        this.restClientServiceTracker.open();
        Thread.sleep(500L);
        Activator.discoverResources();
        if (!"NSCL".equals(Constants.SCL_TYPE) && Constants.NSCL_AUTHENTICATION) {
            LOGGER.info((Object)"Authenticating to NSCl...");
            Activator.registerScl();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Stopping SCL");
        DBAccess.getInstance().close();
    }

    private static void discoverResources() {
        LOGGER.info((Object)"Discover loacl resources");
        String base = "http://localhost:" + Constants.SCL_PORT + Constants.SCL_CONTEXT + "/";
        RequestIndication request = new RequestIndication("RETRIEVE", String.valueOf(Constants.SCL_ID) + "/discovery", Constants.ADMIN_REQUESTING_ENTITY);
        request.setBase(base);
        new RestClient().sendRequest(request);
    }

    public static void initScl() {
        LOGGER.info((Object)"Init JPA DB Access");
        DBAccess.getInstance().init();
        LOGGER.info((Object)"Create SclBase resource");
        Activator.initSclBase();
        LOGGER.info((Object)"Create AccessRight resource");
        Activator.initAccessRight();
        LOGGER.info((Object)"Init XmlMapper");
        XmlMapper.getInstance();
        LOGGER.info((Object)"Init ObixMapper");
        ObixMapper.getInstance();
    }

    public static void initSclBase() {
        SclBase sclBase = new SclBase();
        sclBase.setUri(Constants.SCL_ID);
        sclBase.setAccessRightID(String.valueOf(sclBase.getUri()) + "/accessRights" + "/" + "AR_ADMIN");
        sclBase.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        sclBase.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        SearchStrings searchStrings = new SearchStrings();
        searchStrings.getSearchString().add("ResourceType/" + sclBase.getClass().getSimpleName());
        searchStrings.getSearchString().add("ResourceID/" + Constants.SCL_ID);
        sclBase.setSearchStrings(searchStrings);
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        if (DAOFactory.getSclBaseDAO().find(sclBase.getUri(), em) == null) {
            DAOFactory.getSclBaseDAO().create(sclBase, em);
        } else {
            DAOFactory.getSclBaseDAO().update(sclBase, em);
        }
        em.getTransaction().commit();
        em.close();
    }

    public static void registerScl() {
        Scl gscl = new Scl();
        gscl.setSclId(Constants.SCL_ID);
        AnyURIList pocs = new AnyURIList();
        pocs.getReference().add("http://" + Constants.SCL_IP + ":" + Constants.SCL_PORT + Constants.SCL_CONTEXT);
        gscl.setPocs(pocs);
        gscl.setLink(Constants.SCL_ID);
        gscl.setMgmtProtocolType(MgmtProtocolType.OMA_DM);
        String base = String.valueOf(Constants.SCL_DEFAULT_PROTOCOL) + "://" + Constants.NSCL_IP + ":" + Constants.NSCL_PORT + Constants.NSCL_CONTEXT + "/";
        final RequestIndication requestIndication = new RequestIndication();
        requestIndication.setMethod("CREATE");
        requestIndication.setRequestingEntity(Constants.ADMIN_REQUESTING_ENTITY);
        requestIndication.setTargetID(String.valueOf(Constants.NSCL_ID) + "/scls");
        requestIndication.setRepresentation(XmlMapper.getInstance().objectToXml((Object)gscl));
        requestIndication.setBase(base);
        LOGGER.info((Object)("The requestIndication : " + requestIndication));
        new Thread(){

            @Override
            public void run() {
                int sleepTime = 10000;
                boolean registred = false;
                while (!registred) {
                    LOGGER.info((Object)"Send GSCL registration to NSCL");
                    ResponseConfirm responseConfirm = new RestClient().sendRequest(requestIndication);
                    if (responseConfirm.getStatusCode().equals((Object)StatusCode.STATUS_CREATED)) {
                        LOGGER.info((Object)"GSCL is successfully registered to NSCL");
                        registred = true;
                        continue;
                    }
                    if (responseConfirm.getStatusCode().equals((Object)StatusCode.STATUS_CONFLICT)) {
                        LOGGER.info((Object)"GSCL is already registered to NSCL");
                        registred = true;
                        continue;
                    }
                    try {
                        LOGGER.info((Object)"GSCL registration failed");
                        LOGGER.info((Object)("Retrying registration after: " + sleepTime + " ms"));
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)"Registration sleep error", (Throwable)e);
                    }
                }
                EntityManager em = DBAccess.createEntityManager();
                em.getTransaction().begin();
                Scl findScl = DAOFactory.getSclDAO().find(String.valueOf(Constants.SCL_ID) + "/scls/" + Constants.NSCL_ID, em);
                em.close();
                if (findScl == null) {
                    Router.readWriteLock.readLock().lock();
                    LOGGER.info((Object)"Create NSCL registration on GSCL");
                    Scl nscl = new Scl();
                    nscl.setUri(String.valueOf(Constants.SCL_ID) + "/scls" + "/" + Constants.NSCL_ID);
                    nscl.setSclId(Constants.NSCL_ID);
                    nscl.setAccessRightID(String.valueOf(Constants.SCL_ID) + "/accessRights" + "/" + "AR_ADMIN");
                    nscl.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
                    nscl.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
                    SearchStrings searchStrings = new SearchStrings();
                    searchStrings.getSearchString().add("ResourceType/" + nscl.getClass().getSimpleName());
                    searchStrings.getSearchString().add("ResourceID/" + Constants.NSCL_ID);
                    nscl.setSearchStrings(searchStrings);
                    AnyURIList pocs = new AnyURIList();
                    pocs.getReference().add("http://" + Constants.NSCL_IP + ":" + Constants.NSCL_PORT + Constants.NSCL_CONTEXT);
                    nscl.setPocs(pocs);
                    nscl.setLink(Constants.NSCL_ID);
                    nscl.setMgmtProtocolType(MgmtProtocolType.OMA_DM);
                    nscl.setOnlineStatus(OnlineStatus.ONLINE);
                    nscl.setServerCapability(Boolean.valueOf(true));
                    nscl.setContainersReference(String.valueOf(nscl.getUri()) + "/containers");
                    nscl.setGroupsReference(String.valueOf(nscl.getUri()) + "/groups");
                    nscl.setApplicationsReference(String.valueOf(nscl.getUri()) + "/applications");
                    nscl.setAccessRightsReference(String.valueOf(nscl.getUri()) + "/accessRights");
                    nscl.setSubscriptionsReference(String.valueOf(nscl.getUri()) + "/subscriptions");
                    nscl.setMgmtObjsReference(String.valueOf(nscl.getUri()) + "/mgmtObjs");
                    nscl.setNotificationChannelsReference(String.valueOf(nscl.getUri()) + "/notificationChannels");
                    nscl.setM2MPocsReference(String.valueOf(nscl.getUri()) + "/m2mPocs");
                    nscl.setAttachedDevicesReference(String.valueOf(nscl.getUri()) + "/attachedDevices");
                    em = DBAccess.createEntityManager();
                    em.getTransaction().begin();
                    DAOFactory.getSclDAO().create(nscl, em);
                    em.getTransaction().commit();
                    em.close();
                    LOGGER.info((Object)"NSCL is successfully registred on GSCL");
                    Router.readWriteLock.readLock().unlock();
                }
            }
        }.start();
    }

    public static void initAccessRight() {
        AccessRight accessRight = new AccessRight();
        accessRight.setId("AR_ADMIN");
        accessRight.setAccessRightID(String.valueOf(Constants.SCL_ID) + "/accessRights" + "/" + "AR_ADMIN");
        accessRight.setUri(String.valueOf(Constants.SCL_ID) + "/accessRights" + "/" + accessRight.getId());
        accessRight.setSubscriptionsReference(String.valueOf(accessRight.getUri()) + "/subscriptions");
        SearchStrings searchStrings = new SearchStrings();
        searchStrings.getSearchString().add("ResourceType/" + accessRight.getClass().getSimpleName());
        searchStrings.getSearchString().add("ResourceID/" + accessRight.getId());
        accessRight.setSearchStrings(searchStrings);
        PermissionListType permissions = new PermissionListType();
        PermissionType permission1 = new PermissionType();
        permission1.setId("Admin_Permission");
        PermissionFlagListType permissionFlagListType = new PermissionFlagListType();
        permissionFlagListType.getFlag().add(PermissionFlagType.CREATE);
        permissionFlagListType.getFlag().add(PermissionFlagType.WRITE);
        permissionFlagListType.getFlag().add(PermissionFlagType.READ);
        permissionFlagListType.getFlag().add(PermissionFlagType.DELETE);
        permissionFlagListType.getFlag().add(PermissionFlagType.DISCOVER);
        PermissionHolderType permissionHolderType = new PermissionHolderType();
        HolderRefListType holderRefListType = new HolderRefListType();
        holderRefListType.getHolderRef().add(Constants.ADMIN_REQUESTING_ENTITY);
        permissionHolderType.setHolderRefs(holderRefListType);
        permission1.setPermissionFlags(permissionFlagListType);
        permission1.setPermissionHolders(permissionHolderType);
        permissions.getPermission().add(permission1);
        PermissionType permission2 = new PermissionType();
        permission2.setId("AR_GUEST");
        PermissionFlagListType permissionFlagListType2 = new PermissionFlagListType();
        permissionFlagListType2.getFlag().add(PermissionFlagType.READ);
        permissionFlagListType2.getFlag().add(PermissionFlagType.DISCOVER);
        PermissionHolderType permissionHolderType2 = new PermissionHolderType();
        HolderRefListType holderRefListType2 = new HolderRefListType();
        holderRefListType2.getHolderRef().add(Constants.GUEST_REQUESTING_ENTITY);
        permissionHolderType2.setHolderRefs(holderRefListType2);
        permission2.setPermissionFlags(permissionFlagListType2);
        permission2.setPermissionHolders(permissionHolderType2);
        permissions.getPermission().add(permission2);
        accessRight.setPermissions(permissions);
        PermissionListType selfPermissions = new PermissionListType();
        PermissionType selfPermission1 = new PermissionType();
        selfPermission1.setId("Self_Permission");
        PermissionFlagListType selfPermissionFlagListType = new PermissionFlagListType();
        selfPermissionFlagListType.getFlag().add(PermissionFlagType.CREATE);
        selfPermissionFlagListType.getFlag().add(PermissionFlagType.WRITE);
        selfPermissionFlagListType.getFlag().add(PermissionFlagType.READ);
        selfPermissionFlagListType.getFlag().add(PermissionFlagType.DELETE);
        selfPermissionFlagListType.getFlag().add(PermissionFlagType.DISCOVER);
        PermissionHolderType selfPermissionHolderType = new PermissionHolderType();
        HolderRefListType selfPermissionHolderRefListType = new HolderRefListType();
        selfPermissionHolderRefListType.getHolderRef().add(Constants.ADMIN_REQUESTING_ENTITY);
        selfPermissionHolderType.setHolderRefs(selfPermissionHolderRefListType);
        selfPermission1.setPermissionFlags(selfPermissionFlagListType);
        selfPermission1.setPermissionHolders(selfPermissionHolderType);
        selfPermissions.getPermission().add(selfPermission1);
        accessRight.setSelfPermissions(selfPermissions);
        accessRight.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        accessRight.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        if (DAOFactory.getAccessRightDAO().find(accessRight.getUri(), em) == null) {
            DAOFactory.getAccessRightDAO().create(accessRight, em);
        } else {
            DAOFactory.getAccessRightDAO().update(accessRight, em);
        }
        em.getTransaction().commit();
        em.close();
    }
}

