/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.comm.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.comm.service.RestClientService;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;

public class RestHttpClient
implements RestClientService {
    private static Log LOGGER = LogFactory.getLog(RestHttpClient.class);
    private static String protocol = "http";

    public String getProtocol() {
        return protocol;
    }

    public ResponseConfirm sendRequest(RequestIndication requestIndication) {
        LOGGER.debug((Object)("Http Client > " + requestIndication));
        HttpClient httpclient = new HttpClient();
        ResponseConfirm responseConfirm = new ResponseConfirm();
        PutMethod httpMethod = null;
        String url = requestIndication.getUrl();
        if (!url.startsWith(String.valueOf(protocol) + "://")) {
            url = String.valueOf(protocol) + "://" + url;
        }
        try {
            switch (requestIndication.getMethod()) {
                case "RETRIEVE": {
                    httpMethod = new GetMethod(url);
                    break;
                }
                case "CREATE": {
                    httpMethod = new PostMethod(url);
                    ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(requestIndication.getRepresentation(), "application/xml", "UTF8"));
                    break;
                }
                case "UPDATE": {
                    httpMethod = new PutMethod(url);
                    httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity(requestIndication.getRepresentation(), "application/xml", "UTF8"));
                    break;
                }
                case "DELETE": {
                    httpMethod = new DeleteMethod(url);
                    break;
                }
                case "EXECUTE": {
                    httpMethod = new PostMethod(url);
                    break;
                }
                default: {
                    ResponseConfirm responseConfirm2 = new ResponseConfirm();
                    return responseConfirm2;
                }
            }
            try {
                httpMethod.addRequestHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])requestIndication.getRequestingEntity().getBytes())));
                httpMethod.setQueryString(RestHttpClient.getQueryFromParams(requestIndication.getParameters()));
                int statusCode = httpclient.executeMethod((HttpMethod)httpMethod);
                responseConfirm.setStatusCode(RestHttpClient.getRestStatusCode(statusCode));
                if (statusCode != 204 && httpMethod.getResponseBody() != null) {
                    responseConfirm.setRepresentation(new String(httpMethod.getResponseBody()));
                }
                if (statusCode == 201 && httpMethod.getResponseHeader("Location").getValue() != null) {
                    responseConfirm.setResourceURI(httpMethod.getResponseHeader("Location").getValue());
                }
                LOGGER.debug((Object)("Http Client > " + responseConfirm));
            }
            catch (IOException e) {
                LOGGER.error((Object)(String.valueOf(url) + " Not Found" + responseConfirm), (Throwable)e);
            }
        }
        finally {
            httpMethod.releaseConnection();
            httpclient.getHttpConnectionManager().closeIdleConnections(0L);
        }
        return responseConfirm;
    }

    public static StatusCode getRestStatusCode(int statusCode) {
        switch (statusCode) {
            case 200: {
                return StatusCode.STATUS_OK;
            }
            case 204: {
                return StatusCode.STATUS_OK;
            }
            case 202: {
                return StatusCode.STATUS_ACCEPTED;
            }
            case 201: {
                return StatusCode.STATUS_CREATED;
            }
            case 400: {
                return StatusCode.STATUS_BAD_REQUEST;
            }
            case 401: {
                return StatusCode.STATUS_PERMISSION_DENIED;
            }
            case 402: {
                return StatusCode.STATUS_AUTHORIZATION_NOT_ADDED;
            }
            case 403: {
                return StatusCode.STATUS_FORBIDDEN;
            }
            case 404: {
                return StatusCode.STATUS_NOT_FOUND;
            }
            case 405: {
                return StatusCode.STATUS_METHOD_NOT_ALLOWED;
            }
            case 406: {
                return StatusCode.STATUS_NOT_ACCEPTABLE;
            }
            case 408: {
                return StatusCode.STATUS_REQUEST_TIMEOUT;
            }
            case 409: {
                return StatusCode.STATUS_CONFLICT;
            }
            case 415: {
                return StatusCode.STATUS_UNSUPPORTED_MEDIA_TYPE;
            }
            case 500: {
                return StatusCode.STATUS_INTERNAL_SERVER_ERROR;
            }
            case 501: {
                return StatusCode.STATUS_NOT_IMPLEMENTED;
            }
            case 502: {
                return StatusCode.STATUS_BAD_GATEWAY;
            }
            case 503: {
                return StatusCode.STATUS_SERVICE_UNAVAILABLE;
            }
            case 504: {
                return StatusCode.STATUS_GATEWAY_TIMEOUT;
            }
            case 410: {
                return StatusCode.STATUS_EXPIRED;
            }
        }
        return StatusCode.STATUS_INTERNAL_SERVER_ERROR;
    }

    public static String getQueryFromParams(Map<String, List<String>> params) {
        List<Object> values = new ArrayList();
        if (params != null) {
            String query = "?";
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next().toString();
                values = params.get(name);
                int i = 0;
                while (i < values.size()) {
                    query = String.valueOf(query) + name + "=" + (String)values.get(i) + "&";
                    ++i;
                }
            }
            return query;
        }
        return null;
    }
}

