/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.MgmtCmd;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.MgmtObjs;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class MgmtObjsDAO
extends DAO<MgmtObjs> {
    @Override
    public void create(MgmtObjs resource, EntityManager em) {
    }

    @Override
    public MgmtObjs find(String uri, EntityManager em) {
        MgmtObjs mgmtObjs = new MgmtObjs();
        mgmtObjs.setUri(uri);
        if (mgmtObjs != null) {
            mgmtObjs.getMgmtObjCollection().getNamedReference().clear();
            mgmtObjs.getMgmtCmdCollection().getNamedReference().clear();
            String q = DBUtil.generateLikeRequest("MGMTOBJ", uri);
            Query query = em.createQuery(q);
            List result = query.getResultList();
            for (MgmtObj obj : result) {
                ReferenceToNamedResource reference = new ReferenceToNamedResource();
                reference.setId(obj.getId());
                reference.setValue(obj.getUri());
                mgmtObjs.getMgmtObjCollection().getNamedReference().add(reference);
            }
            String q2 = DBUtil.generateLikeRequest("MGMTCMD", uri);
            Query query2 = em.createQuery(q2);
            List result2 = query2.getResultList();
            for (MgmtCmd cmd : result2) {
                ReferenceToNamedResource reference = new ReferenceToNamedResource();
                reference.setId(cmd.getId());
                reference.setValue(cmd.getUri());
                mgmtObjs.getMgmtObjCollection().getNamedReference().add(reference);
            }
        }
        return mgmtObjs;
    }

    @Override
    public void update(MgmtObjs resource, EntityManager em) {
    }

    @Override
    public void delete(MgmtObjs resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("MGMTOBJ", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (MgmtObj obj : result) {
            obj.setSubscriptionsReference(String.valueOf(obj.getUri()) + "/subscriptions");
            DAOFactory.getMgmtObjDAO().delete(obj, em);
        }
        String q2 = DBUtil.generateLikeRequest("MGMTCMD", resource.getUri());
        Query query2 = em.createQuery(q2);
        List result2 = query2.getResultList();
        for (MgmtCmd cmd : result2) {
            cmd.setExecInstancesReference(String.valueOf(cmd.getUri()) + "/execInstances");
            cmd.setSubscriptionsReference(String.valueOf(cmd.getUri()) + "/subscriptions");
            DAOFactory.getMgmtCmdDAO().delete(cmd, em);
        }
    }
}

