/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.AccessRight;
import org.eclipse.om2m.commons.resource.AccessRightAnnc;
import org.eclipse.om2m.commons.resource.AccessRights;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class AccessRightsDAO
extends DAO<AccessRights> {
    @Override
    public void create(AccessRights resource, EntityManager em) {
    }

    @Override
    public AccessRights find(String uri, EntityManager em) {
        AccessRights accessRights = new AccessRights();
        accessRights.setUri(uri);
        accessRights.getAccessRightCollection().getNamedReference().clear();
        accessRights.getAccessRightAnncCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("ACCESSRIGHT", uri);
        Query query = em.createQuery(q);
        List arList = query.getResultList();
        for (AccessRight ar : arList) {
            ReferenceToNamedResource reference = new ReferenceToNamedResource();
            reference.setId(ar.getId());
            reference.setValue(ar.getUri());
            accessRights.getAccessRightCollection().getNamedReference().add(reference);
        }
        String r = DBUtil.generateLikeRequest("ACCESSRIGHTANNC", uri);
        Query query2 = em.createQuery(r);
        List araList = query2.getResultList();
        for (AccessRightAnnc ara : araList) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(ara.getId());
            ref.setValue(ara.getUri());
            accessRights.getAccessRightAnncCollection().getNamedReference().add(ref);
        }
        return accessRights;
    }

    @Override
    public void update(AccessRights resource, EntityManager em) {
    }

    @Override
    public void delete(AccessRights resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("ACCESSRIGHT", resource.getUri());
        Query query = em.createQuery(q);
        List arList = query.getResultList();
        for (AccessRight ar : arList) {
            ar.setSubscriptionsReference(String.valueOf(ar.getUri()) + "/subscriptions");
            DAOFactory.getAccessRightDAO().delete(ar, em);
        }
        String r = DBUtil.generateLikeRequest("ACCESSRIGHTANNC", resource.getUri());
        Query query2 = em.createQuery(r);
        List araList = query2.getResultList();
        for (AccessRightAnnc ara : araList) {
            DAOFactory.getAccessRightAnncDAO().delete(ara, em);
        }
    }
}

