/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.resource;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.LocationContainer;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.SearchStrings;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={LocationContainer.class})
@XmlRootElement
@Entity(name="CONTAINER")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Container
extends Resource {
    @XmlSchemaType(name="dateTime")
    protected String expirationTime;
    @XmlSchemaType(name="dateTime")
    protected String creationTime;
    @XmlSchemaType(name="dateTime")
    protected String lastModifiedTime;
    @Embedded
    protected AnnounceTo announceTo;
    protected Long maxNrOfInstances;
    protected Long maxByteSize;
    protected Long maxInstanceAge;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String contentInstancesReference;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String subscriptionsReference;
    @XmlAttribute(name="id", namespace="http://uri.etsi.org/m2m")
    @XmlSchemaType(name="anyURI")
    protected String id;

    public Container() {
    }

    public Container(String id) {
        this.id = id;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String value) {
        this.expirationTime = value;
    }

    @Override
    public SearchStrings getSearchStrings() {
        return this.searchStrings;
    }

    @Override
    public void setSearchStrings(SearchStrings value) {
        this.searchStrings = value;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String value) {
        this.creationTime = value;
    }

    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String value) {
        this.lastModifiedTime = value;
    }

    public AnnounceTo getAnnounceTo() {
        return this.announceTo;
    }

    public void setAnnounceTo(AnnounceTo value) {
        this.announceTo = value;
    }

    public Long getMaxNrOfInstances() {
        return this.maxNrOfInstances;
    }

    public void setMaxNrOfInstances(Long value) {
        this.maxNrOfInstances = value;
    }

    public Long getMaxByteSize() {
        return this.maxByteSize;
    }

    public void setMaxByteSize(Long value) {
        this.maxByteSize = value;
    }

    public Long getMaxInstanceAge() {
        return this.maxInstanceAge;
    }

    public void setMaxInstanceAge(Long value) {
        this.maxInstanceAge = value;
    }

    public String getContentInstancesReference() {
        if (this.contentInstancesReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/contentInstances";
        }
        return this.contentInstancesReference;
    }

    public void setContentInstancesReference(String value) {
        this.contentInstancesReference = value;
    }

    public String getSubscriptionsReference() {
        if (this.subscriptionsReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/subscriptions";
        }
        return this.subscriptionsReference;
    }

    public void setSubscriptionsReference(String value) {
        this.subscriptionsReference = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "Container [expirationTime=" + this.expirationTime + ", accessRightID=" + this.accessRightID + ", searchStrings=" + this.searchStrings + ", creationTime=" + this.creationTime + ", lastModifiedTime=" + this.lastModifiedTime + ", announceTo=" + this.announceTo + ", maxNrOfInstances=" + this.maxNrOfInstances + ", maxByteSize=" + this.maxByteSize + ", maxInstanceAge=" + this.maxInstanceAge + ", contentInstancesReference=" + this.contentInstancesReference + ", subscriptionsReference=" + this.subscriptionsReference + ", id=" + this.id + ", uri=" + this.uri + "]";
    }
}

