/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation.RoleTypeInfo;
import org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation.TypeCreator;
import org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation.TypeInfo;

public class RoleCreator
extends TypeCreator {
    @Override
    protected String createDefaultSupertypeName() {
        return "java.lang.Object";
    }

    @Override
    protected void writeInheritanceRelations(TypeCreator.ImportsManager imports, StringBuffer buf) throws CoreException {
        super.writeInheritanceRelations(imports, buf);
        ImportRewrite importsRewrite = this.getTypeInfo().isInlineType() ? imports.fImportsRewrite : imports.fTeamImportsRewrite;
        this.writeBaseClass(buf, importsRewrite);
    }

    private void writeBaseClass(StringBuffer buf, ImportRewrite imports) throws CoreException {
        TypeInfo typeInfo = this.getTypeInfo();
        if (!(typeInfo instanceof RoleTypeInfo)) {
            return;
        }
        RoleTypeInfo roleTypeInfo = (RoleTypeInfo)typeInfo;
        String baseName = roleTypeInfo.getBaseTypeName();
        if (baseName != null && baseName.trim().length() > 0) {
            buf.append(" playedBy ");
            ITypeBinding binding = null;
            IType currentType = roleTypeInfo.getCurrentType();
            if (currentType != null && (binding = TypeContextChecker.resolveSuperClass((String)baseName, (IType)currentType, (StubTypeContext)this.getBaseTypeStubTypeContext())) == null) {
                binding = TypeContextChecker.resolveSuperInterfaces((String[])new String[]{baseName}, (IType)currentType, (StubTypeContext)this.getSuperInterfacesStubTypeContext())[0];
            }
            if (binding != null) {
                if (this.hasCommonEnclosingTeam(currentType, binding)) {
                    buf.append(binding.getName());
                } else {
                    buf.append(imports.addImport(binding));
                    imports.setImportBase((IBinding)binding);
                }
            } else {
                buf.append(imports.addImportBase(baseName));
            }
        }
    }

    private boolean hasCommonEnclosingTeam(IType type, ITypeBinding binding) {
        IType currentElement = type;
        while ((currentElement = currentElement.getParent()) instanceof IType) {
            IType currentType = currentElement;
            if (!OTModelManager.isTeam((IType)currentType)) continue;
            ITypeBinding currentBinding = binding;
            while ((currentBinding = currentBinding.getDeclaringClass()) != null) {
                if (!currentBinding.getQualifiedName().equals(currentType.getFullyQualifiedName('.'))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void validateTypeCreation() throws CoreException {
        if (this.getTypeInfo().getEnclosingTypeName().trim().length() == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", 0, "The role class " + this.getTypeInfo().getTypeName() + " must have an enclosing team.", null));
        }
    }
}

