/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CreateSwitchAdapter
extends AbstractTransformableClassNode {
    private Method method;
    private int firstArgIndex;
    private String superToCall;

    public CreateSwitchAdapter(Method method) {
        this.method = method;
        this.firstArgIndex = method.isStatic() ? 0 : 1;
    }

    public CreateSwitchAdapter(Method method, String superToCall) {
        this.method = method;
        this.firstArgIndex = method.isStatic() ? 0 : 1;
        this.superToCall = superToCall;
    }

    public CreateSwitchAdapter(Method method, boolean isRoleMethod) {
        this.method = method;
        this.firstArgIndex = method.isStatic() ? (isRoleMethod ? 2 : 0) : 1;
    }

    @Override
    public boolean transform() {
        MethodNode methodNode = this.getMethod(this.method);
        if (methodNode == null) {
            return false;
        }
        methodNode.instructions.clear();
        this.addLineNumber(methodNode.instructions, 1);
        this.addPreSwitchInstructions(methodNode);
        LabelNode def = new LabelNode();
        LookupSwitchInsnNode switchNode = new LookupSwitchInsnNode(def, new int[0], new LabelNode[0]);
        methodNode.instructions.add((AbstractInsnNode)switchNode);
        methodNode.instructions.add((AbstractInsnNode)def);
        this.addInstructionForDefaultLabel(methodNode);
        this.addPostSwitchInstructions(methodNode);
        if ((methodNode.access & 8) == 0) {
            this.addThisVariable(methodNode);
        }
        methodNode.maxStack = this.getMaxStack();
        return true;
    }

    protected void addPostSwitchInstructions(MethodNode method) {
    }

    protected void addPreSwitchInstructions(MethodNode method) {
        method.instructions.add((AbstractInsnNode)new VarInsnNode(21, this.firstArgIndex));
        method.instructions.add(this.createLoadIntConstant(Integer.MAX_VALUE));
        method.instructions.add((AbstractInsnNode)new InsnNode(126));
    }

    protected void addInstructionForDefaultLabel(MethodNode method) {
        if (this.superToCall != null) {
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.superToCall, this.method.getName(), this.method.getSignature(), false));
        } else {
            method.instructions.add((AbstractInsnNode)new InsnNode(1));
        }
        method.instructions.add((AbstractInsnNode)new InsnNode(176));
    }

    protected int getMaxStack() {
        return 1;
    }

    protected int getFirstArgIndex() {
        return this.firstArgIndex;
    }

    protected Method getMethod() {
        return this.method;
    }
}

