/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;

public class ClassNameConfigLabelAccumulator
implements IConfigLabelProvider {
    private IRowDataProvider<?> dataProvider;

    public ClassNameConfigLabelAccumulator(IRowDataProvider<?> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabel, int columnPosition, int rowPosition) {
        Object value = this.dataProvider.getDataValue(columnPosition, rowPosition);
        if (value != null) {
            configLabel.addLabel(value.getClass().getName());
        }
    }

    @Override
    public Collection<String> getProvidedLabels() {
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < this.dataProvider.getColumnCount()) {
            Object value = this.dataProvider.getDataValue(i, 0);
            if (value != null) {
                result.add(value.getClass().getName());
            }
            ++i;
        }
        return result;
    }
}

