/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.poi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.extension.poi.ExcelCellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.formula.FormulaParser;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.VerticalTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PoiExcelExporter
implements ILayerExporter {
    private static final Logger LOG = LoggerFactory.getLogger(PoiExcelExporter.class);
    private final IOutputStreamProvider outputStreamProvider;
    private Map<ExcelCellStyleAttributes, CellStyle> xlCellStyles;
    protected Workbook xlWorkbook;
    protected int sheetNumber;
    protected Sheet xlSheet;
    protected Row xlRow;
    private boolean applyBackgroundColor = true;
    private boolean applyVerticalTextConfiguration = false;
    private boolean applyTextWrapping = false;
    private boolean applyColumnWidths = false;
    private boolean applyRowHeights = false;
    private boolean applyCellBorders = false;
    private String sheetname;
    protected FormulaParser formulaParser;
    protected NumberFormat nf = NumberFormat.getInstance();
    protected CreationHelper helper;
    protected Drawing<?> drawing;
    protected boolean exportOnSameSheet = false;
    protected int currentRow = 0;
    private Set<Integer> hiddenColumnPositions = new HashSet<Integer>();

    public PoiExcelExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    public void exportBegin(OutputStream outputStream) throws IOException {
        this.xlCellStyles = new HashMap<ExcelCellStyleAttributes, CellStyle>();
        this.xlWorkbook = this.createWorkbook();
        this.hiddenColumnPositions.clear();
    }

    public void exportEnd(OutputStream outputStream) throws IOException {
        this.xlWorkbook.write(outputStream);
        this.xlCellStyles = null;
        this.xlWorkbook = null;
        this.sheetNumber = 0;
        this.xlSheet = null;
        this.xlRow = null;
        this.drawing = null;
        this.currentRow = 0;
    }

    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        ++this.sheetNumber;
        if (!(layerName != null && layerName.length() != 0 || (layerName = this.sheetname) != null && layerName.length() != 0)) {
            layerName = "Sheet" + this.sheetNumber;
        }
        this.xlSheet = this.xlWorkbook.createSheet(layerName);
    }

    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
    }

    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
        int pos = this.exportOnSameSheet ? this.currentRow : rowPosition;
        this.xlRow = this.xlSheet.getRow(pos);
        if (this.xlRow == null) {
            this.xlRow = this.xlSheet.createRow(pos);
        }
        ++this.currentRow;
    }

    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
    }

    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        Cell xlCell;
        if (cell.getLayer().getColumnWidthByPosition(cell.getColumnPosition()) == 0) {
            this.hiddenColumnPositions.add(cell.getColumnPosition());
            return;
        }
        int columnPosition = cell.getColumnPosition();
        if (!this.hiddenColumnPositions.isEmpty()) {
            for (int hidden : this.hiddenColumnPositions) {
                if (hidden >= cell.getColumnPosition()) continue;
                --columnPosition;
            }
        }
        int rowPosition = cell.getRowPosition();
        if (this.applyColumnWidths && cell.getColumnSpan() == 1) {
            this.xlSheet.setColumnWidth(columnPosition, this.getPoiColumnWidth(cell.getBounds().width) + this.getPoiColumnWidth(5));
        }
        if (this.applyRowHeights && cell.getRowSpan() == 1) {
            this.xlRow.setHeight(this.getPoiRowHeight(cell.getBounds().height));
        }
        if ((xlCell = this.xlRow.getCell(columnPosition)) != null) {
            return;
        }
        xlCell = this.xlRow.createCell(columnPosition);
        CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, DisplayMode.NORMAL, (List)cell.getConfigLabels());
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        org.eclipse.swt.graphics.Font font = (org.eclipse.swt.graphics.Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        FontData fontData = font.getFontData()[0];
        String dataFormat = this.getDataFormatString(exportDisplayValue, cell, configRegistry);
        int hAlign = HorizontalAlignmentEnum.getSWTStyle((IStyle)cellStyle);
        int vAlign = VerticalAlignmentEnum.getSWTStyle((IStyle)cellStyle);
        ICellPainter cellPainter = (ICellPainter)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, (List)cell.getConfigLabels());
        boolean vertical = this.applyVerticalTextConfiguration && this.isVertical(cellPainter);
        boolean wrap = this.applyTextWrapping && this.wrapText(cellPainter);
        CellStyle xlCellStyle = this.getExcelCellStyle(fg, bg, fontData, dataFormat, hAlign, vAlign, vertical, wrap, this.applyCellBorders);
        xlCell.setCellStyle(xlCellStyle);
        int columnSpan = cell.getColumnSpan();
        if (columnSpan > 1) {
            int col = cell.getOriginColumnPosition();
            while (col < cell.getOriginColumnPosition() + cell.getColumnSpan()) {
                if (cell.getLayer().getColumnWidthByPosition(col) == 0) {
                    --columnSpan;
                }
                ++col;
            }
        }
        int rowSpan = cell.getRowSpan();
        if (columnSpan > 1 || rowSpan > 1) {
            int lastRow = rowPosition + rowSpan - 1;
            int lastColumn = columnPosition + columnSpan - 1;
            this.xlSheet.addMergedRegion(new CellRangeAddress(rowPosition, lastRow, columnPosition, lastColumn));
            Row tempRow = null;
            Cell tempCell = null;
            int i = rowPosition;
            while (i <= lastRow) {
                tempRow = this.xlSheet.getRow(i);
                if (tempRow == null) {
                    tempRow = this.xlSheet.createRow(i);
                }
                int j = columnPosition;
                while (j <= lastColumn) {
                    tempCell = tempRow.getCell(j);
                    if (tempCell == null) {
                        tempCell = tempRow.createCell(j);
                    }
                    tempCell.setCellStyle(xlCellStyle);
                    ++j;
                }
                ++i;
            }
        }
        if (exportDisplayValue == null) {
            exportDisplayValue = "";
        }
        if (exportDisplayValue instanceof Boolean) {
            xlCell.setCellValue(((Boolean)exportDisplayValue).booleanValue());
        } else if (exportDisplayValue instanceof Calendar) {
            xlCell.setCellValue((Calendar)exportDisplayValue);
        } else if (exportDisplayValue instanceof Date) {
            xlCell.setCellValue((Date)exportDisplayValue);
        } else if (exportDisplayValue instanceof Number) {
            xlCell.setCellValue(((Number)exportDisplayValue).doubleValue());
        } else if (exportDisplayValue instanceof InputStream) {
            this.exportImage((InputStream)exportDisplayValue, xlCell);
        } else if (this.formulaParser != null) {
            String cellValue = exportDisplayValue.toString();
            if (this.formulaParser.isFunction(cellValue)) {
                String functionString = this.formulaParser.getFunctionOnly(cellValue);
                functionString = functionString.replace(',', '.');
                functionString = functionString.replace(';', ',');
                xlCell.setCellFormula(functionString);
            } else if (this.formulaParser.isNumber(cellValue)) {
                try {
                    xlCell.setCellValue(this.nf.parse(cellValue).doubleValue());
                }
                catch (ParseException e) {
                    throw new IOException("Error on parsing number value: " + cellValue, e);
                }
            } else {
                xlCell.setCellValue(exportDisplayValue.toString());
            }
        } else {
            xlCell.setCellValue(exportDisplayValue.toString());
        }
    }

    private boolean isVertical(ICellPainter cellPainter) {
        if (cellPainter instanceof VerticalTextPainter) {
            return true;
        }
        if (cellPainter instanceof CellPainterWrapper) {
            return this.isVertical(((CellPainterWrapper)cellPainter).getWrappedPainter());
        }
        if (cellPainter instanceof CellPainterDecorator) {
            return this.isVertical(((CellPainterDecorator)cellPainter).getBaseCellPainter()) || this.isVertical(((CellPainterDecorator)cellPainter).getDecoratorCellPainter());
        }
        return false;
    }

    private boolean wrapText(ICellPainter cellPainter) {
        if (cellPainter instanceof AbstractTextPainter) {
            return ((AbstractTextPainter)cellPainter).isWordWrapping() || ((AbstractTextPainter)cellPainter).isWrapText();
        }
        if (cellPainter instanceof CellPainterWrapper) {
            return this.wrapText(((CellPainterWrapper)cellPainter).getWrappedPainter());
        }
        if (cellPainter instanceof CellPainterDecorator) {
            return this.wrapText(((CellPainterDecorator)cellPainter).getBaseCellPainter()) || this.wrapText(((CellPainterDecorator)cellPainter).getDecoratorCellPainter());
        }
        return false;
    }

    private CellStyle getExcelCellStyle(Color fg, Color bg, FontData fontData, String dataFormat, int hAlign, int vAlign, boolean vertical, boolean wrap, boolean border) {
        CellStyle xlCellStyle = this.xlCellStyles.get(new ExcelCellStyleAttributes(fg, bg, fontData, dataFormat, hAlign, vAlign, vertical, wrap, border));
        if (xlCellStyle == null) {
            xlCellStyle = this.xlWorkbook.createCellStyle();
            if (this.applyBackgroundColor) {
                this.setFillForegroundColor(xlCellStyle, bg);
                xlCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            Font xlFont = this.xlWorkbook.createFont();
            this.setFontColor(xlFont, fg);
            xlFont.setFontName(fontData.getName());
            xlFont.setFontHeightInPoints((short)fontData.getHeight());
            xlCellStyle.setFont(xlFont);
            if (vertical) {
                xlCellStyle.setRotation((short)90);
            }
            if (wrap) {
                xlCellStyle.setWrapText(wrap);
            }
            if (border) {
                xlCellStyle.setBorderTop(BorderStyle.THIN);
                xlCellStyle.setBorderRight(BorderStyle.THIN);
                xlCellStyle.setBorderBottom(BorderStyle.THIN);
                xlCellStyle.setBorderLeft(BorderStyle.THIN);
            }
            switch (hAlign) {
                case 0x1000000: {
                    xlCellStyle.setAlignment(HorizontalAlignment.CENTER);
                    break;
                }
                case 16384: {
                    xlCellStyle.setAlignment(HorizontalAlignment.LEFT);
                    break;
                }
                case 131072: {
                    xlCellStyle.setAlignment(HorizontalAlignment.RIGHT);
                }
            }
            switch (vAlign) {
                case 128: {
                    xlCellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                    break;
                }
                case 0x1000000: {
                    xlCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    break;
                }
                case 1024: {
                    xlCellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                }
            }
            if (dataFormat != null) {
                CreationHelper createHelper = this.xlWorkbook.getCreationHelper();
                xlCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(dataFormat));
            }
            this.xlCellStyles.put(new ExcelCellStyleAttributes(fg, bg, fontData, dataFormat, hAlign, vAlign, vertical, wrap, border), xlCellStyle);
        }
        return xlCellStyle;
    }

    protected String getDataFormatString(Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) {
        String dataFormat = null;
        if (exportDisplayValue instanceof Calendar || exportDisplayValue instanceof Date) {
            dataFormat = this.getDataFormatString(cell, configRegistry);
        } else if (exportDisplayValue instanceof Number) {
            dataFormat = (String)configRegistry.getConfigAttribute(ExportConfigAttributes.NUMBER_FORMAT, DisplayMode.NORMAL, (List)cell.getConfigLabels());
        }
        return dataFormat;
    }

    protected String getDataFormatString(ILayerCell cell, IConfigRegistry configRegistry) {
        String dataFormat = (String)configRegistry.getConfigAttribute(ExportConfigAttributes.DATE_FORMAT, DisplayMode.NORMAL, (List)cell.getConfigLabels());
        if (dataFormat == null) {
            dataFormat = "m/d/yy h:mm";
        }
        return dataFormat;
    }

    public void setApplyBackgroundColor(boolean applyBackgroundColor) {
        this.applyBackgroundColor = applyBackgroundColor;
    }

    public void setApplyVerticalTextConfiguration(boolean inspectVertical) {
        this.applyVerticalTextConfiguration = inspectVertical;
    }

    public void setApplyTextWrapping(boolean inspectTextWrap) {
        this.applyTextWrapping = inspectTextWrap;
    }

    public void setApplyCellDimensions(boolean apply) {
        this.applyColumnWidths = apply;
        this.applyRowHeights = apply;
    }

    public void setApplyColumnWidths(boolean apply) {
        this.applyColumnWidths = apply;
    }

    public void setApplyRowHeights(boolean apply) {
        this.applyRowHeights = apply;
    }

    public void setApplyCellBorders(boolean apply) {
        this.applyCellBorders = apply;
    }

    protected abstract Workbook createWorkbook();

    protected abstract void setFillForegroundColor(CellStyle var1, Color var2);

    protected abstract void setFontColor(Font var1, Color var2);

    public Object getResult() {
        return this.outputStreamProvider.getResult();
    }

    public void setSheetname(String sheetname) {
        this.sheetname = sheetname;
    }

    public void setFormulaParser(FormulaParser formulaParser) {
        this.formulaParser = formulaParser;
    }

    public void setNumberFormat(NumberFormat nf) {
        this.nf = nf;
    }

    protected void exportImage(InputStream is, Cell xlCell) {
        try {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                int pictureIdx = this.xlWorkbook.addPicture(bytes, 6);
                if (this.helper == null) {
                    this.helper = this.xlWorkbook.getCreationHelper();
                }
                if (this.drawing == null) {
                    this.drawing = this.xlSheet.createDrawingPatriarch();
                }
                ClientAnchor anchor = this.helper.createClientAnchor();
                anchor.setCol1(xlCell.getColumnIndex());
                anchor.setRow1(xlCell.getRowIndex());
                Picture pict = this.drawing.createPicture(anchor, pictureIdx);
                pict.resize();
            }
            catch (IOException e) {
                LOG.error("Error on transforming the image input stream to byte array", (Throwable)e);
                try {
                    is.close();
                }
                catch (IOException e2) {
                    LOG.error("Error on closing the image input stream", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error("Error on closing the image input stream", (Throwable)e);
            }
        }
    }

    public void setExportOnSameSheet(boolean sameSheet) {
        this.exportOnSameSheet = sameSheet;
    }

    private int getPoiColumnWidth(int pixel) {
        return 256 * (pixel / 7) + 128;
    }

    private short getPoiRowHeight(int pixel) {
        double points = pixel;
        points *= 72.0;
        points /= 96.0;
        return (short)((points *= 21.0) + 32.0);
    }
}

