/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public final class GraphicsUtils {
    private GraphicsUtils() {
    }

    public static void drawVerticalText(String string, int x, int y, GC gc, int style) {
        GraphicsUtils.drawVerticalText(string, x, y, false, false, true, gc, style);
    }

    public static void drawVerticalText(String string, int x, int y, boolean underline, boolean strikethrough, boolean paintBackground, GC gc, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string.trim());
        Image stringImage = new Image((Device)display, pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        try {
            stringGc.setAntialias(gc.getAntialias());
            stringGc.setTextAntialias(gc.getTextAntialias());
            stringGc.setForeground(gc.getForeground());
            stringGc.setBackground(gc.getBackground());
            stringGc.setFont(gc.getFont());
            stringGc.fillRectangle(0, 0, pt.x, pt.y);
            stringGc.drawText(string, 0, 0);
            if (underline || strikethrough) {
                if (underline) {
                    int underlineY = pt.y - stringGc.getFontMetrics().getDescent() / 2;
                    stringGc.drawLine(0, underlineY, pt.x, underlineY);
                }
                if (strikethrough) {
                    int strikeY = pt.y / 2 + stringGc.getFontMetrics().getLeading() / 2;
                    stringGc.drawLine(0, strikeY, pt.x, strikeY);
                }
            }
            GraphicsUtils.drawVerticalImage(stringImage, x, y, paintBackground, gc, style);
        }
        finally {
            stringGc.dispose();
            stringImage.dispose();
        }
    }

    public static void drawVerticalImage(Image image, int x, int y, GC gc, int style) {
        GraphicsUtils.drawVerticalImage(image, x, y, true, gc, style);
    }

    public static void drawVerticalImage(Image image, int x, int y, boolean paintBackground, GC gc, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        dd.transparentPixel = sd.transparentPixel;
        if (!paintBackground) {
            dd.transparentPixel = sd.palette.getPixel(gc.getBackground().getRGB());
        }
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        Image vertical = new Image((Device)display, dd);
        gc.drawImage(vertical, x, y);
        vertical.dispose();
    }

    public static Image createRotatedText(String text, Font font, Color foreground, Color background, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        GC gc = new GC((Drawable)display);
        Image stringImage = null;
        try {
            Image image;
            gc.setFont(font);
            Point pt = gc.textExtent(text);
            gc.dispose();
            stringImage = new Image((Device)display, pt.x, pt.y);
            gc = new GC((Drawable)stringImage);
            gc.setFont(font);
            gc.setForeground(foreground);
            gc.setBackground(background);
            gc.drawText(text, 0, 0);
            Image image2 = image = GraphicsUtils.createRotatedImage(stringImage, style);
            return image2;
        }
        finally {
            gc.dispose();
            if (stringImage != null) {
                stringImage.dispose();
            }
        }
    }

    public static Image createRotatedImage(Image image, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        return new Image((Device)display, dd);
    }

    public static void drawLineHorizontal(GC gc, int x, int y, int width) {
        if (width == 0) {
            return;
        }
        int x2 = width > 0 ? x + width - 1 : x + width + 1;
        if (x2 < x) {
            ++x;
        } else {
            int lineWidth = gc.getLineWidth();
            if (lineWidth != 1) {
                ++x2;
            }
        }
        gc.drawLine(x, y, x2, y);
    }

    public static void drawLineHorizontal(GC gc, int x, int y, int width, boolean drawLeftCorner, boolean drawRightCorner) {
        if (width == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        if (width > 0) {
            if (drawLeftCorner) {
                x -= lineWidth / 2;
                width += lineWidth / 2;
            }
            if (drawRightCorner) {
                width += (lineWidth - 1) / 2;
            }
        } else {
            if (drawRightCorner) {
                x += (lineWidth - 1) / 2;
                width -= (lineWidth - 1) / 2;
            }
            if (drawLeftCorner) {
                width -= lineWidth / 2;
            }
        }
        GraphicsUtils.drawLineHorizontal(gc, x, y, width);
    }

    public static void drawLineVertical(GC gc, int x, int y, int height) {
        if (height == 0) {
            return;
        }
        int y2 = height > 0 ? y + height - 1 : y + height + 1;
        if (y2 < y) {
            ++y;
        } else {
            int lineWidth = gc.getLineWidth();
            if (lineWidth != 1) {
                ++y2;
            }
        }
        gc.drawLine(x, y, x, y2);
    }

    public static void drawLineVertical(GC gc, int x, int y, int height, boolean drawTopCorner, boolean drawBottomCorner) {
        if (height == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        if (height > 0) {
            if (drawTopCorner) {
                y -= lineWidth / 2;
                height += lineWidth / 2;
            }
            if (drawBottomCorner) {
                height += (lineWidth - 1) / 2;
            }
        } else {
            if (drawBottomCorner) {
                y += (lineWidth - 1) / 2;
                height -= (lineWidth - 1) / 2;
            }
            if (drawTopCorner) {
                height -= lineWidth / 2;
            }
        }
        GraphicsUtils.drawLineVertical(gc, x, y, height);
    }

    public static void drawLineHorizontalBorderBottom(GC gc, int x, int y, int width) {
        if (width == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        GraphicsUtils.drawLineHorizontal(gc, x, y += lineWidth / 2, width);
    }

    public static void drawLineHorizontalBorderBottom(GC gc, int x, int y, int width, boolean drawLeftCorner, boolean drawRightCorner) {
        if (width == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        if (width > 0) {
            if (drawLeftCorner) {
                x -= lineWidth - 1;
                width += lineWidth - 1;
            }
            if (drawRightCorner) {
                width += lineWidth - 1;
            }
        } else {
            if (drawRightCorner) {
                x += lineWidth - 1;
                width -= lineWidth - 1;
            }
            if (drawLeftCorner) {
                width -= lineWidth - 1;
            }
        }
        GraphicsUtils.drawLineHorizontalBorderBottom(gc, x, y, width);
    }

    public static void drawLineHorizontalBorderTop(GC gc, int x, int y, int width) {
        if (width == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        GraphicsUtils.drawLineHorizontal(gc, x, y -= (lineWidth - 1) / 2, width);
    }

    public static void drawLineHorizontalBorderTop(GC gc, int x, int y, int width, boolean drawLeftCorner, boolean drawRightCorner) {
        if (width == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        if (width > 0) {
            if (drawLeftCorner) {
                x -= lineWidth - 1;
                width += lineWidth - 1;
            }
            if (drawRightCorner) {
                width += lineWidth - 1;
            }
        } else {
            if (drawRightCorner) {
                x += lineWidth - 1;
                width -= lineWidth - 1;
            }
            if (drawLeftCorner) {
                width -= lineWidth - 1;
            }
        }
        GraphicsUtils.drawLineHorizontalBorderTop(gc, x, y, width);
    }

    public static void drawLineVerticalBorderRight(GC gc, int x, int y, int height) {
        if (height == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        GraphicsUtils.drawLineVertical(gc, x += lineWidth / 2, y, height);
    }

    public static void drawLineVerticalBorderRight(GC gc, int x, int y, int height, boolean drawTopCorner, boolean drawBottomCorner) {
        if (height == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        if (height > 0) {
            if (drawTopCorner) {
                y -= lineWidth - 1;
                height += lineWidth - 1;
            }
            if (drawBottomCorner) {
                height += lineWidth - 1;
            }
        } else {
            if (drawBottomCorner) {
                y += lineWidth - 1;
                height -= lineWidth - 1;
            }
            if (drawTopCorner) {
                height -= lineWidth - 1;
            }
        }
        GraphicsUtils.drawLineVerticalBorderRight(gc, x, y, height);
    }

    public static void drawLineVerticalBorderLeft(GC gc, int x, int y, int height) {
        if (height == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        GraphicsUtils.drawLineVertical(gc, x -= (lineWidth - 1) / 2, y, height);
    }

    public static void drawLineVerticalBorderLeft(GC gc, int x, int y, int height, boolean drawTopCorner, boolean drawBottomCorner) {
        if (height == 0) {
            return;
        }
        int lineWidth = gc.getLineWidth();
        if (height > 0) {
            if (drawTopCorner) {
                y -= lineWidth - 1;
                height += lineWidth - 1;
            }
            if (drawBottomCorner) {
                height += lineWidth - 1;
            }
        } else {
            if (drawBottomCorner) {
                y += lineWidth - 1;
                height -= lineWidth - 1;
            }
            if (drawTopCorner) {
                height -= lineWidth - 1;
            }
        }
        GraphicsUtils.drawLineVerticalBorderLeft(gc, x, y, height);
    }

    public static void fillRectangle(GC gc, Rectangle rect) {
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (rectangle.width < 0) {
            ++rectangle.x;
        }
        if (rectangle.height < 0) {
            ++rectangle.y;
        }
        gc.fillRectangle(rectangle);
    }

    public static void drawRectangle(GC gc, Rectangle rect, BorderStyle borderStyle) {
        int originalLineStyle = gc.getLineStyle();
        int originalLineWidth = gc.getLineWidth();
        Color originalForeground = gc.getForeground();
        gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
        gc.setLineWidth(borderStyle.getThickness());
        gc.setForeground(borderStyle.getColor());
        switch (borderStyle.getBorderMode()) {
            case CENTERED: {
                GraphicsUtils.drawRectangle(gc, rect);
                break;
            }
            case INTERNAL: {
                GraphicsUtils.drawRectangleBorderInternal(gc, rect);
                break;
            }
            case EXTERNAL: {
                GraphicsUtils.drawRectangleBorderExternal(gc, rect);
            }
        }
        gc.setLineStyle(originalLineStyle);
        gc.setLineWidth(originalLineWidth);
        gc.setForeground(originalForeground);
    }

    public static void drawRectangle(GC gc, Rectangle rect) {
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        int absWidth = Math.abs(rectangle.width);
        int absHeight = Math.abs(rectangle.height);
        if (absWidth == 1 && absHeight == 1) {
            int lineWidth = gc.getLineWidth();
            rectangle.x -= lineWidth / 2;
            rectangle.y -= lineWidth / 2;
            rectangle.width = rectangle.width + lineWidth - 1;
            rectangle.height = rectangle.height + lineWidth - 1;
            Color originalBackground = gc.getBackground();
            gc.setBackground(gc.getForeground());
            GraphicsUtils.fillRectangle(gc, rectangle);
            gc.setBackground(originalBackground);
            return;
        }
        if (absWidth == 1) {
            GraphicsUtils.drawLineVertical(gc, rectangle.x, rectangle.y, rectangle.height);
            return;
        }
        if (absHeight == 1) {
            GraphicsUtils.drawLineHorizontal(gc, rectangle.x, rectangle.y, rectangle.width);
            return;
        }
        if (rectangle.width < 0) {
            ++rectangle.x;
        }
        if (rectangle.height < 0) {
            ++rectangle.y;
        }
        --rectangle.width;
        --rectangle.height;
        gc.drawRectangle(rectangle);
    }

    public static void drawRectangleBorderInternal(GC gc, Rectangle rect) {
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        int lineWidth = gc.getLineWidth();
        int absWidth = Math.abs(rectangle.width);
        if (absWidth == 1) {
            if (lineWidth != 1) {
                gc.setLineWidth(1);
            }
            GraphicsUtils.drawLineVertical(gc, rectangle.x, rectangle.y, rectangle.height);
            if (lineWidth != 1) {
                gc.setLineWidth(lineWidth);
            }
            return;
        }
        int absHeight = Math.abs(rectangle.height);
        if (absHeight == 1) {
            if (lineWidth != 1) {
                gc.setLineWidth(1);
            }
            GraphicsUtils.drawLineHorizontal(gc, rectangle.x, rectangle.y, rectangle.width);
            if (lineWidth != 1) {
                gc.setLineWidth(lineWidth);
            }
            return;
        }
        int minSide = Math.min(absWidth, absHeight);
        if (minSide <= lineWidth * 2) {
            Color originalBackground = gc.getBackground();
            gc.setBackground(gc.getForeground());
            GraphicsUtils.fillRectangle(gc, rectangle);
            gc.setBackground(originalBackground);
            return;
        }
        if (rectangle.width > 0) {
            rectangle.x += lineWidth / 2;
            rectangle.width -= lineWidth - 1;
        } else {
            rectangle.x -= (lineWidth - 1) / 2;
            rectangle.width += lineWidth - 1;
        }
        if (rectangle.height > 0) {
            rectangle.y += lineWidth / 2;
            rectangle.height -= lineWidth - 1;
        } else {
            rectangle.y -= (lineWidth - 1) / 2;
            rectangle.height += lineWidth - 1;
        }
        GraphicsUtils.drawRectangle(gc, rectangle);
    }

    public static void drawRectangleBorderExternal(GC gc, Rectangle rect) {
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        int lineWidth = gc.getLineWidth();
        if (rectangle.width > 0) {
            rectangle.x -= (lineWidth - 1) / 2;
            rectangle.width += lineWidth - 1;
        } else {
            rectangle.x += lineWidth / 2;
            rectangle.width -= lineWidth - 1;
        }
        if (rectangle.height > 0) {
            rectangle.y -= (lineWidth - 1) / 2;
            rectangle.height += lineWidth - 1;
        } else {
            rectangle.y += lineWidth / 2;
            rectangle.height -= lineWidth - 1;
        }
        GraphicsUtils.drawRectangle(gc, rectangle);
    }

    public static Rectangle getResultingExternalBounds(Rectangle rectangle, BorderStyle borderStyle) {
        if (rectangle == null || borderStyle == null) {
            return null;
        }
        Rectangle resultingRectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int borderWidth = borderStyle.getThickness();
        BorderStyle.BorderModeEnum borderMode = borderStyle.getBorderMode();
        switch (borderMode) {
            case CENTERED: {
                if (borderWidth > 0) {
                    resultingRectangle.x -= borderWidth / 2;
                    resultingRectangle.width += borderWidth - 1;
                } else {
                    resultingRectangle.x -= borderWidth / 2;
                    resultingRectangle.width += borderWidth + 1;
                }
                if (borderWidth > 0) {
                    resultingRectangle.y -= borderWidth / 2;
                    resultingRectangle.height += borderWidth - 1;
                    break;
                }
                resultingRectangle.y -= borderWidth / 2;
                resultingRectangle.height += borderWidth + 1;
                break;
            }
            case EXTERNAL: {
                if (borderWidth > 0) {
                    resultingRectangle.x -= borderWidth - 1;
                    resultingRectangle.width += (borderWidth - 1) * 2;
                } else {
                    resultingRectangle.x -= borderWidth + 1;
                    resultingRectangle.width += (borderWidth + 1) * 2;
                }
                if (borderWidth > 0) {
                    resultingRectangle.y -= borderWidth - 1;
                    resultingRectangle.height += (borderWidth - 1) * 2;
                    break;
                }
                resultingRectangle.y -= borderWidth + 1;
                resultingRectangle.height += (borderWidth + 1) * 2;
                break;
            }
        }
        return resultingRectangle;
    }

    public static Rectangle getInternalBounds(Rectangle rectangle, BorderStyle borderStyle) {
        if (rectangle == null || borderStyle == null) {
            return null;
        }
        Rectangle resultingRectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int borderWidth = borderStyle.getThickness();
        BorderStyle.BorderModeEnum borderMode = borderStyle.getBorderMode();
        switch (borderMode) {
            case CENTERED: {
                if (borderWidth > 0) {
                    resultingRectangle.x += borderWidth / 2;
                    resultingRectangle.width -= borderWidth - 1;
                } else {
                    resultingRectangle.x += borderWidth / 2;
                    resultingRectangle.width -= borderWidth + 1;
                }
                if (borderWidth > 0) {
                    resultingRectangle.y += borderWidth / 2;
                    resultingRectangle.height -= borderWidth - 1;
                    break;
                }
                resultingRectangle.y += borderWidth / 2;
                resultingRectangle.height -= borderWidth + 1;
                break;
            }
            case EXTERNAL: {
                if (borderWidth > 0) {
                    resultingRectangle.x += borderWidth - 1;
                    resultingRectangle.width -= (borderWidth - 1) * 2;
                } else {
                    resultingRectangle.x += borderWidth + 1;
                    resultingRectangle.width -= (borderWidth + 1) * 2;
                }
                if (borderWidth > 0) {
                    resultingRectangle.y += borderWidth - 1;
                    resultingRectangle.height -= (borderWidth - 1) * 2;
                    break;
                }
                resultingRectangle.y += borderWidth + 1;
                resultingRectangle.height -= (borderWidth + 1) * 2;
                break;
            }
        }
        return resultingRectangle;
    }
}

