/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchQuery;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchResultEvent;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchPlugin;
import org.eclipse.mylyn.sandbox.search.ui.SearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public class DesktopSearchResult
implements ISearchResult {
    private final List<ISearchResultListener> listeners = new CopyOnWriteArrayList<ISearchResultListener>();
    private final List<SearchResult> items = new ArrayList<SearchResult>();
    private final DesktopSearchQuery searchQuery;
    private boolean searchInProgres;

    public DesktopSearchResult(DesktopSearchQuery searchQuery) {
        this.searchQuery = searchQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        List<SearchResult> list = this.items;
        synchronized (list) {
            return this.items.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<SearchResult> list = this.items;
        synchronized (list) {
            this.items.clear();
        }
        this.fire(DesktopSearchResultEvent.Kind.CLEARED, new SearchResult[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> getItems() {
        List<SearchResult> list = this.items;
        synchronized (list) {
            return new ArrayList<SearchResult>(this.items);
        }
    }

    private void fire(DesktopSearchResultEvent.Kind eventKind, SearchResult ... items) {
        DesktopSearchResultEvent event = new DesktopSearchResultEvent(this, eventKind, items);
        for (ISearchResultListener listener : this.listeners) {
            listener.searchResultChanged((SearchResultEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SearchResult item) {
        if (this.filtered(item)) {
            return;
        }
        List<SearchResult> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
        this.fire(DesktopSearchResultEvent.Kind.ADDED, item);
    }

    private boolean filtered(SearchResult item) {
        return !item.getFile().isFile();
    }

    public void addListener(ISearchResultListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISearchResultListener listener) {
        this.listeners.remove(listener);
    }

    public String getLabel() {
        return this.searchQuery.getResultLabel(this.isSearchInProgres(), this.getSize());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return SearchPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/elcl16/tsearch_obj.gif");
    }

    public ISearchQuery getQuery() {
        return this.searchQuery;
    }

    public void setSearchInProgres(boolean searchInProgres) {
        boolean previous = this.searchInProgres;
        if (previous != searchInProgres) {
            this.searchInProgres = searchInProgres;
            this.fire(DesktopSearchResultEvent.Kind.SEARCH_STATUS, new SearchResult[0]);
        }
    }

    public boolean isSearchInProgres() {
        return this.searchInProgres;
    }
}

