/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.internal.sandbox.search.ui.OpenFileAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PropertyDialogAction;

class DesktopSearchActionGroup
extends ActionGroup {
    private final IViewPart viewPart;
    private final PropertyDialogAction propertyDialogAction;
    private final OpenFileAction openFileAction;

    DesktopSearchActionGroup(IViewPart viewPart) {
        this.viewPart = viewPart;
        this.propertyDialogAction = new PropertyDialogAction((IShellProvider)viewPart.getSite(), viewPart.getSite().getSelectionProvider());
        this.openFileAction = new OpenFileAction(viewPart.getViewSite().getPage());
    }

    public void dispose() {
        this.propertyDialogAction.dispose();
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.addOpenWithMenu(menu, (IStructuredSelection)selection);
            if (this.propertyDialogAction.isEnabled() && this.propertyDialogAction.isApplicableForSelection((IStructuredSelection)selection)) {
                menu.appendToGroup("group.properties", (IAction)this.propertyDialogAction);
            }
        }
    }

    private void addOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        Object firstElement;
        this.openFileAction.selectionChanged(selection);
        if (this.openFileAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openFileAction);
        }
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IAdaptable) {
            MenuManager menuManager = new MenuManager(Messages.DesktopSearchActionGroup_MenuOpenWith);
            menuManager.add((IContributionItem)new OpenWithMenu(this.viewPart.getViewSite().getPage(), (IAdaptable)firstElement));
            menu.appendToGroup("group.open", (IContributionItem)menuManager);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
    }
}

