/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.wikitext.commonmark.internal.CommonMark;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LinePredicates;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.TextSegment;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.HtmlType7Block;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.IndentedCodeBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.SetextHeaderBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.ReferenceDefinition;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class ParagraphBlock
extends SourceBlock {
    private final Set<Class<? extends SourceBlock>> INTERRUPTION_EXCLUSIONS = ImmutableSet.of(IndentedCodeBlock.class, SetextHeaderBlock.class, HtmlType7Block.class);

    @Override
    public void createContext(ProcessingContextBuilder contextBuilder, LineSequence lineSequence) {
        TextSegment textSegment = this.extractTextSegment(lineSequence);
        contextBuilder.getInlineParser().createContext(contextBuilder, textSegment);
    }

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        this.processInlines(context, builder, lineSequence, true);
    }

    void processInlines(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence, boolean asBlock) {
        TextSegment textSegment = this.extractTextSegment(lineSequence);
        List<Inline> inlines = context.getInlineParser().parse(context, textSegment);
        if (!this.emptyParagraph(inlines)) {
            builder.setLocator(textSegment.getLines().get(0).toLocator());
            if (asBlock) {
                builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            }
            InlineParser.emit(builder, inlines);
            if (asBlock) {
                builder.endBlock();
            }
        }
    }

    private boolean emptyParagraph(List<Inline> inlines) {
        for (Inline inline : inlines) {
            if (inline instanceof ReferenceDefinition) continue;
            return false;
        }
        return true;
    }

    private TextSegment extractTextSegment(LineSequence lineSequence) {
        ArrayList<Line> lines = new ArrayList<Line>();
        while (lineSequence.getCurrentLine() != null && this.notEmptyLine(lineSequence) && !this.anotherBlockStart(lineSequence)) {
            lines.add(lineSequence.getCurrentLine());
            lineSequence.advance();
        }
        return new TextSegment(lines);
    }

    private boolean notEmptyLine(LineSequence lineSequence) {
        return LinePredicates.empty().negate().test(lineSequence.getCurrentLine());
    }

    private boolean anotherBlockStart(LineSequence lineSequence) {
        SourceBlock block = CommonMark.sourceBlocks().selectBlock(lineSequence);
        return block != null && !ParagraphBlock.class.isAssignableFrom(block.getClass()) && !this.INTERRUPTION_EXCLUSIONS.contains(block.getClass());
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        return line != null && !line.isEmpty();
    }
}

