/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.token;

import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class NumericEntityReferenceReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "&#(\\d+);";
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new NumericEntityReferenceReplacementTokenProcessor();
    }

    private static class NumericEntityReferenceReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private NumericEntityReferenceReplacementTokenProcessor() {
        }

        public void emit() {
            String character = this.group(1);
            int characterValue = Integer.parseInt(character);
            if (characterValue >= 32 && Character.isValidCodePoint(characterValue)) {
                this.getBuilder().characters(Character.valueOf((char)characterValue).toString());
            }
        }
    }
}

