/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ExpectationTypeParameterHintCollector
extends DeferredTypeParameterHintCollector {
    public ExpectationTypeParameterHintCollector(ITypeReferenceOwner owner) {
        super(owner);
    }

    @Override
    protected TypeParameterSubstitutor<?> createTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping) {
        return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
    }

    @Override
    protected AbstractTypeReferencePairWalker.WildcardTypeReferenceTraverser createWildcardTypeReferenceTraverser() {
        return new DeferredWildcardTypeReferenceTraverser();
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new DeferredParameterizedTypeReferenceTraverser();
    }

    @Override
    protected AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
        return new DeferredArrayTypeReferenceTraverser();
    }

    protected class DeferredArrayTypeReferenceTraverser
    extends AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser {
        protected DeferredArrayTypeReferenceTraverser() {
        }

        public void doVisitUnboundTypeReference(UnboundTypeReference reference, ArrayTypeReference declaration) {
            boolean constraintSeen = false;
            boolean constraintsMatch = true;
            boolean othersSeen = false;
            boolean declarationMatches = ExpectationTypeParameterHintCollector.this.getExpectedVariance() != VarianceInfo.OUT;
            List<LightweightBoundTypeArgument> hints = reference.getAllHints();
            int i = 0;
            while (i < hints.size()) {
                LightweightBoundTypeArgument hint = hints.get(i);
                if (hint.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                    constraintSeen = true;
                    ExpectationTypeParameterHintCollector.this.outerVisit(hint.getTypeReference(), declaration, (Object)hint.getSource(), hint.getDeclaredVariance(), hint.getActualVariance());
                    if (constraintsMatch && !hint.getTypeReference().isAssignableFrom(declaration)) {
                        constraintsMatch = false;
                    }
                } else {
                    othersSeen = true;
                    if (declarationMatches) {
                        if (hint.getActualVariance() == VarianceInfo.OUT && hint.getDeclaredVariance() == VarianceInfo.OUT && (hint.getSource() == BoundTypeArgumentSource.INFERRED || hint.getSource() == BoundTypeArgumentSource.INFERRED_LATER)) {
                            if (!declaration.isAssignableFrom(hint.getTypeReference())) {
                                declarationMatches = false;
                            }
                        } else {
                            declarationMatches = false;
                        }
                    }
                }
                ++i;
            }
            if (constraintSeen && constraintsMatch && !othersSeen) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else if (!constraintSeen && !reference.internalIsResolved() && declaration.isResolved() && !ExpectationTypeParameterHintCollector.this.getOwner().isResolved(reference.getHandle()) && reference.canResolveTo(declaration)) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else if (othersSeen && declarationMatches) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else {
                reference.tryResolve();
                if (reference.internalIsResolved()) {
                    ExpectationTypeParameterHintCollector.this.outerVisit(reference, declaration);
                } else {
                    ExpectationTypeParameterHintCollector.this.addHint(reference, declaration);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DeferredParameterizedTypeReferenceTraverser
    extends AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser {
        protected DeferredParameterizedTypeReferenceTraverser() {
        }

        @Override
        public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
            boolean declarationMatches;
            boolean constraintSeen = false;
            boolean constraintsMatch = true;
            boolean othersSeen = false;
            boolean bl = declarationMatches = ExpectationTypeParameterHintCollector.this.getExpectedVariance() != VarianceInfo.OUT;
            if (reference.getTypeParameter() != declaration.getType()) {
                List<LightweightBoundTypeArgument> hints = reference.getAllHints();
                int i = 0;
                while (i < hints.size()) {
                    LightweightBoundTypeArgument hint = hints.get(i);
                    if (hint.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                        constraintSeen = true;
                        ExpectationTypeParameterHintCollector.this.outerVisit(hint.getTypeReference(), declaration, (Object)hint.getSource(), hint.getDeclaredVariance(), hint.getActualVariance());
                        if (constraintsMatch && !hint.getTypeReference().isAssignableFrom(declaration)) {
                            constraintsMatch = false;
                        }
                    } else {
                        othersSeen = true;
                        if (declarationMatches) {
                            if (hint.getActualVariance() == VarianceInfo.OUT && hint.getDeclaredVariance() == VarianceInfo.OUT && (hint.getSource() == BoundTypeArgumentSource.INFERRED || hint.getSource() == BoundTypeArgumentSource.INFERRED_LATER)) {
                                if (!declaration.isAssignableFrom(hint.getTypeReference())) {
                                    declarationMatches = false;
                                }
                            } else {
                                declarationMatches = false;
                            }
                        }
                    }
                    ++i;
                }
            } else if (ExpectationTypeParameterHintCollector.this.getOwner().getDeclaredTypeParameters().contains(reference.getTypeParameter())) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
                return;
            }
            if (constraintSeen && constraintsMatch && !othersSeen) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else if (!constraintSeen && !reference.internalIsResolved() && declaration.isResolved() && !ExpectationTypeParameterHintCollector.this.getOwner().isResolved(reference.getHandle()) && reference.canResolveTo(declaration)) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else if (othersSeen && declarationMatches) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else {
                reference.tryResolve();
                if (reference.internalIsResolved()) {
                    ExpectationTypeParameterHintCollector.this.outerVisit(reference, declaration);
                } else {
                    ExpectationTypeParameterHintCollector.this.addHint(reference, declaration);
                }
            }
        }

        @Override
        protected boolean shouldProcessInContextOf(JvmTypeParameter declaredTypeParameter, Set<JvmTypeParameter> boundParameters, Set<JvmTypeParameter> visited) {
            if (ExpectationTypeParameterHintCollector.this.getOwner().getDeclaredTypeParameters().contains(declaredTypeParameter)) {
                return true;
            }
            return !boundParameters.contains(declaredTypeParameter) || visited.add(declaredTypeParameter);
        }
    }

    protected class DeferredWildcardTypeReferenceTraverser
    extends AbstractTypeReferencePairWalker.WildcardTypeReferenceTraverser {
        protected DeferredWildcardTypeReferenceTraverser() {
        }

        public void doVisitUnboundTypeReference(UnboundTypeReference reference, WildcardTypeReference declaration) {
            if (declaration.getLowerBound() == null && !reference.internalIsResolved()) {
                List<LightweightTypeReference> upperBounds = declaration.getUpperBounds();
                for (LightweightTypeReference upperBound : upperBounds) {
                    if (upperBound.isResolved() && reference.canResolveTo(upperBound)) continue;
                    super.doVisitUnboundTypeReference(reference, declaration);
                    return;
                }
                reference.tryResolve();
                if (reference.internalIsResolved()) {
                    ExpectationTypeParameterHintCollector.this.outerVisit(reference, declaration);
                } else {
                    ExpectationTypeParameterHintCollector.this.addHint(reference, declaration);
                }
                return;
            }
            super.doVisitUnboundTypeReference(reference, declaration);
        }
    }
}

