/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorDelegateScope;
import org.eclipse.xtext.xbase.scoping.batch.DynamicExtensionsScope;
import org.eclipse.xtext.xbase.scoping.batch.ExpressionBucket;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.LocalVariableScope;
import org.eclipse.xtext.xbase.scoping.batch.NestedTypeLiteralScope;
import org.eclipse.xtext.xbase.scoping.batch.ReceiverFeatureScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureOnTypeLiteralScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.SynonymTypeBucket;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.batch.TypeLiteralScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;

public class FeatureScopes
implements IFeatureNames {
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private IResolvedFeatures.Provider resolvedFeaturesProvider;
    @Inject
    private SynonymTypesProvider synonymProvider;
    @Inject(optional=true)
    private XbaseFactory xbaseFactory = XbaseFactory.eINSTANCE;
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;

    public IScope createFeatureCallScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!(context instanceof XAbstractFeatureCall)) {
            return IScope.NULLSCOPE;
        }
        XAbstractFeatureCall call = (XAbstractFeatureCall)context;
        XExpression syntacticalReceiver = this.getSyntacticalReceiver(call);
        if (syntacticalReceiver == null) {
            IScope result = this.createSimpleFeatureCallScope(call, reference, session, resolvedTypes);
            return result;
        }
        IScope result = this.createFeatureCallScopeForReceiver(call, syntacticalReceiver, reference, session, resolvedTypes);
        return result;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    public IScope createSimpleFeatureCallScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        XFeatureCall featureCall;
        IScope root = IScope.NULLSCOPE;
        if (context instanceof XFeatureCall && !(featureCall = (XFeatureCall)context).isExplicitOperationCallOrBuilderSyntax()) {
            root = this.createTypeLiteralScope(context, root, session, resolvedTypes, QualifiedName.EMPTY);
            if (this.isDefiniteTypeLiteral(featureCall)) {
                return root;
            }
        }
        IScope staticImports = this.createStaticFeaturesScope(context, root, session);
        IScope staticMembers = this.createStaticScope(this.asAbstractFeatureCall(context), null, null, staticImports, session, resolvedTypes);
        IScope staticExtensions = this.createStaticExtensionsScope(null, null, context, staticMembers, session, resolvedTypes);
        IScope dynamicExtensions = this.createDynamicExtensionsScope(null, null, context, staticExtensions, session, resolvedTypes);
        IScope implicitReceivers = this.createImplicitFeatureCallScope(context, dynamicExtensions, session, resolvedTypes);
        IScope constructors = this.createConstructorDelegates(context, implicitReceivers, session, resolvedTypes);
        LocalVariableScope localVariables = new LocalVariableScope(constructors, session, this.asAbstractFeatureCall(context));
        return localVariables;
    }

    protected boolean isDefiniteTypeLiteral(XFeatureCall featureCall) {
        return this.typeLiteralHelper.isDefiniteTypeLiteral(featureCall);
    }

    protected IScope createConstructorDelegates(EObject context, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription = session.getLocalElement(THIS);
        if (thisDescription != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            return new ConstructorDelegateScope(parent, type, session, this.asAbstractFeatureCall(context));
        }
        return parent;
    }

    protected XAbstractFeatureCall asAbstractFeatureCall(EObject context) {
        return context instanceof XAbstractFeatureCall ? (XAbstractFeatureCall)context : null;
    }

    protected IScope createFeatureScopeForTypeRef(final XExpression receiver, final LightweightTypeReference featureDeclarator, final boolean implicit, final EObject featureCall, final IFeatureScopeSession session, final JvmIdentifiableElement receiverFeature, IScope parent) {
        final Wrapper wrapper = Wrapper.wrap((Object)parent);
        this.synonymProvider.collectSynonymTypes(featureDeclarator, new SynonymTypesProvider.Acceptor(){
            int id = 100;

            @Override
            @NonNullByDefault
            protected boolean accept(LightweightTypeReference synonymType, EnumSet<ConformanceHint> hints) {
                List<JvmType> rawTypes = synonymType.getRawTypes();
                SynonymTypeBucket bucket = new SynonymTypeBucket(this.id++, rawTypes, FeatureScopes.this.resolvedFeaturesProvider, hints);
                CompoundTypeReference compoundTypeReference = new CompoundTypeReference(synonymType.getOwner(), true);
                compoundTypeReference.addComponent(featureDeclarator);
                compoundTypeReference.addComponent(synonymType);
                wrapper.set((Object)new ReceiverFeatureScope((IScope)wrapper.get(), session, receiver, compoundTypeReference, implicit, FeatureScopes.this.asAbstractFeatureCall(featureCall), bucket, receiverFeature, FeatureScopes.this.operatorMapping));
                return true;
            }
        });
        if (featureDeclarator.isMultiType()) {
            List<LightweightTypeReference> components = featureDeclarator.getMultiTypeComponents();
            Object result = (IScope)wrapper.get();
            int i = components.size() - 1;
            while (i >= 0) {
                LightweightTypeReference component = components.get(i);
                List<JvmType> rawTypes = component.getRawTypes();
                TypeBucket typeBucket = new TypeBucket(-1 - i, rawTypes, this.resolvedFeaturesProvider);
                result = new ReceiverFeatureScope((IScope)result, session, receiver, featureDeclarator, implicit, this.asAbstractFeatureCall(featureCall), typeBucket, receiverFeature, this.operatorMapping);
                --i;
            }
            return result;
        }
        List<JvmType> rawTypes = featureDeclarator.getRawTypes();
        TypeBucket typeBucket = new TypeBucket(-1, rawTypes, this.resolvedFeaturesProvider);
        ReceiverFeatureScope result = new ReceiverFeatureScope((IScope)wrapper.get(), session, receiver, featureDeclarator, implicit, this.asAbstractFeatureCall(featureCall), typeBucket, receiverFeature, this.operatorMapping);
        return result;
    }

    public IScope createFeatureCallScopeForReceiver(XExpression featureCall, XExpression receiver, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!this.isFeatureCallScope(reference)) {
            return IScope.NULLSCOPE;
        }
        if (receiver == null || receiver.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        LightweightTypeReference receiverType = resolvedTypes.getActualType(receiver);
        if (receiverType != null && !this.isUnknownReceiverType(receiverType)) {
            JvmIdentifiableElement linkedReceiver = resolvedTypes.getLinkedFeature(this.asAbstractFeatureCall(receiver));
            boolean typeLiteral = false;
            IScope root = this.createTypeLiteralScope(featureCall, receiver, session, resolvedTypes, receiverType, linkedReceiver);
            if (root != null) {
                if (featureCall instanceof XMemberFeatureCall && ((XMemberFeatureCall)featureCall).isExplicitStatic()) {
                    return root;
                }
                typeLiteral = true;
            } else {
                root = IScope.NULLSCOPE;
            }
            if (typeLiteral || this.isValidFeatureCallArgument(receiver, linkedReceiver, session)) {
                IScope staticScope = this.createStaticScope(this.asAbstractFeatureCall(featureCall), receiver, receiverType, root, session, resolvedTypes);
                IScope staticExtensionScope = this.createStaticExtensionsScope(receiver, receiverType, featureCall, staticScope, session, resolvedTypes);
                IScope extensionScope = this.createDynamicExtensionsScope(receiver, receiverType, featureCall, staticExtensionScope, session, resolvedTypes);
                return this.createFeatureScopeForTypeRef(receiver, receiverType, false, featureCall, session, linkedReceiver, extensionScope);
            }
            return this.createFeatureScopeForTypeRef(receiver, receiverType, false, featureCall, session, linkedReceiver, IScope.NULLSCOPE);
        }
        if (this.typeLiteralHelper.isPotentialTypeLiteral(featureCall, resolvedTypes)) {
            IScope errorScope = this.createFollowUpErrorScope(receiverType);
            List<String> prefix = this.typeLiteralHelper.getTypeNameSegmentsFromConcreteSyntax((XMemberFeatureCall)featureCall);
            if (prefix == null) {
                return errorScope;
            }
            return this.createTypeLiteralScope(featureCall, errorScope, session, resolvedTypes, QualifiedName.create(prefix));
        }
        return this.createFollowUpErrorScope(receiverType);
    }

    @Nullable
    private IScope createTypeLiteralScope(XExpression featureCall, XExpression receiver, IFeatureScopeSession session, IResolvedTypes resolvedTypes, LightweightTypeReference receiverType, JvmIdentifiableElement linkedReceiver) {
        IFeatureLinkingCandidate candidate;
        if (linkedReceiver instanceof JvmDeclaredType && (candidate = resolvedTypes.getLinkingCandidate(this.asAbstractFeatureCall(receiver))) != null && candidate.isTypeLiteral()) {
            JvmDeclaredType declaringType = (JvmDeclaredType)linkedReceiver;
            NestedTypeLiteralScope result = new NestedTypeLiteralScope(IScope.NULLSCOPE, session, this.asAbstractFeatureCall(featureCall), receiverType, (JvmType)declaringType);
            result = this.createStaticFeatureOnTypeLiteralScope(this.asAbstractFeatureCall(featureCall), (JvmType)declaringType, receiver, receiverType, (IScope)result, session);
            return result;
        }
        return null;
    }

    protected boolean isUnknownReceiverType(LightweightTypeReference receiverType) {
        if (receiverType.isUnknown()) {
            return true;
        }
        if (receiverType instanceof UnboundTypeReference) {
            List<LightweightBoundTypeArgument> hints = ((UnboundTypeReference)receiverType).getAllHints();
            for (LightweightBoundTypeArgument hint : hints) {
                LightweightTypeReference typeReference = hint.getTypeReference();
                if (typeReference == null || !typeReference.isUnknown()) continue;
                return true;
            }
        }
        return false;
    }

    protected IScope createFollowUpErrorScope(final @Nullable LightweightTypeReference receiverType) {
        return new SimpleScope(Collections.emptyList()){

            public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                return Collections.singletonList(new ScopeProviderAccess.ErrorDescription(receiverType));
            }
        };
    }

    protected boolean isValidFeatureCallArgument(XExpression expression, JvmIdentifiableElement linkedReceiver, IFeatureScopeSession session) {
        IEObjectDescription knownSuperType;
        if (linkedReceiver instanceof JvmType && (knownSuperType = session.getLocalElement(SUPER)) != null && linkedReceiver == knownSuperType.getEObjectOrProxy()) {
            return false;
        }
        return !(expression instanceof XAbstractFeatureCall) || linkedReceiver != null && !linkedReceiver.eIsProxy();
    }

    protected IScope createStaticExtensionsScope(XExpression receiver, LightweightTypeReference receiverType, EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        Object result = parent;
        if (receiver == null) {
            result = this.createImplicitExtensionScope(THIS, featureCall, session, resolvedTypes, (IScope)result);
            result = this.createImplicitExtensionScope(IT, featureCall, session, resolvedTypes, (IScope)result);
            return result;
        }
        result = this.createStaticExtensionsScope(receiver, receiverType, false, featureCall, parent, session);
        return result;
    }

    protected IScope createStaticScope(XAbstractFeatureCall featureCall, XExpression receiver, LightweightTypeReference receiverType, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IScope result = parent;
        if (receiver == null) {
            result = this.createImplicitStaticScope(THIS, featureCall, session, resolvedTypes, result);
            result = this.createImplicitStaticScope(IT, featureCall, session, resolvedTypes, result);
            return result;
        }
        TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(receiverType.getType()), this.resolvedFeaturesProvider);
        return new StaticFeatureScope(parent, session, featureCall, receiver, receiverType, receiverBucket, this.operatorMapping);
    }

    protected IScope createStaticFeatureOnTypeLiteralScope(XAbstractFeatureCall featureCall, JvmType type, XExpression receiver, LightweightTypeReference receiverType, IScope parent, IFeatureScopeSession session) {
        TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(type), this.resolvedFeaturesProvider);
        return new StaticFeatureOnTypeLiteralScope(parent, session, featureCall, receiver, receiverType, receiverBucket, this.operatorMapping);
    }

    protected IScope createDynamicExtensionsScope(XExpression firstArgument, LightweightTypeReference firstArgumentType, EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        List<ExpressionBucket> extensionProviders = session.getExtensionProviders();
        if (extensionProviders.isEmpty()) {
            return parent;
        }
        Object result = parent;
        if (firstArgument == null) {
            result = this.createDynamicExtensionsScope(THIS, featureCall, session, resolvedTypes, (IScope)result);
            result = this.createDynamicExtensionsScope(IT, featureCall, session, resolvedTypes, (IScope)result);
            return result;
        }
        result = this.createDynamicExtensionsScope(firstArgument, firstArgumentType, false, featureCall, parent, session);
        return result;
    }

    protected IScope createDynamicExtensionsScope(QualifiedName implicitFirstArgumentName, EObject featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        IEObjectDescription firstArgumentDescription = session.getLocalElement(implicitFirstArgumentName);
        if (firstArgumentDescription != null) {
            JvmIdentifiableElement feature = (JvmIdentifiableElement)firstArgumentDescription.getEObjectOrProxy();
            LightweightTypeReference type = resolvedTypes.getActualType(feature);
            if (type != null && !type.isUnknown()) {
                XFeatureCall implicitArgument = this.xbaseFactory.createXFeatureCall();
                implicitArgument.setFeature(feature);
                return this.createDynamicExtensionsScope((XExpression)implicitArgument, type, true, featureCall, parent, session);
            }
            return parent;
        }
        return this.createDynamicExtensionsScope(null, null, true, featureCall, parent, session);
    }

    protected DynamicExtensionsScope createDynamicExtensionsScope(XExpression firstArgument, LightweightTypeReference argumentType, boolean implicit, EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new DynamicExtensionsScope(parent, session, firstArgument, argumentType, implicit, this.asAbstractFeatureCall(featureCall), this.operatorMapping);
    }

    protected StaticExtensionImportsScope createStaticExtensionsScope(XExpression receiver, LightweightTypeReference receiverType, boolean implicit, EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new StaticExtensionImportsScope(parent, session, receiver, receiverType, implicit, this.asAbstractFeatureCall(featureCall), this.operatorMapping);
    }

    protected XExpression getSyntacticalReceiver(XAbstractFeatureCall call) {
        if (call instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)call).getMemberCallTarget();
        }
        if (call instanceof XBinaryOperation) {
            return ((XBinaryOperation)call).getLeftOperand();
        }
        if (call instanceof XUnaryOperation) {
            return ((XUnaryOperation)call).getOperand();
        }
        if (call instanceof XAssignment) {
            return ((XAssignment)call).getAssignable();
        }
        return null;
    }

    protected IScope createTypeLiteralScope(EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes, QualifiedName parentSegments) {
        return new TypeLiteralScope(parent, session, this.asAbstractFeatureCall(featureCall), resolvedTypes, parentSegments);
    }

    protected IScope createStaticFeaturesScope(EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new StaticImportsScope(parent, session, this.asAbstractFeatureCall(featureCall));
    }

    protected IScope createImplicitFeatureCallScope(EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IScope result = parent;
        result = this.createImplicitFeatureCallScope(THIS, featureCall, session, resolvedTypes, result);
        result = this.createImplicitFeatureCallScope(IT, featureCall, session, resolvedTypes, result);
        return result;
    }

    protected IScope createImplicitFeatureCallScope(QualifiedName implicitName, EObject featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            XFeatureCall implicitReceiver = this.xbaseFactory.createXFeatureCall();
            implicitReceiver.setFeature(thisElement);
            return this.createFeatureScopeForTypeRef(implicitReceiver, type, true, featureCall, session, thisElement, parent);
        }
        return parent;
    }

    protected IScope createImplicitExtensionScope(QualifiedName implicitName, EObject featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            XFeatureCall implicitReceiver = this.xbaseFactory.createXFeatureCall();
            implicitReceiver.setFeature(thisElement);
            return this.createStaticExtensionsScope((XExpression)implicitReceiver, type, true, featureCall, parent, session);
        }
        return parent;
    }

    protected IScope createImplicitStaticScope(QualifiedName implicitName, XAbstractFeatureCall featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(type.getType()), this.resolvedFeaturesProvider);
            return new StaticFeatureScope(parent, session, featureCall, null, type, receiverBucket, this.operatorMapping);
        }
        return parent;
    }
}

